/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.entity.GhostEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GhostModel
extends EntityModel<GhostEntity> {
    private static final String HEAD = "head";
    private static final String BODY = "body";
    private static final String RIGHT_ARM = "right_arm";
    private static final String LEFT_ARM = "left_arm";
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private boolean isAggressive;

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_(BODY, CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition head = body.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition arm_left = body.m_171599_(LEFT_ARM, CubeListBuilder.m_171558_().m_171514_(16, 12).m_171488_(-2.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition arm_right = body.m_171599_(RIGHT_ARM, CubeListBuilder.m_171558_().m_171514_(24, 12).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public GhostModel(@NotNull ModelPart part) {
        this.body = part.m_171324_(BODY);
        this.head = this.body.m_171324_(HEAD);
        this.right_arm = this.body.m_171324_(RIGHT_ARM);
        this.left_arm = this.body.m_171324_(LEFT_ARM);
    }

    public void setupAnim(@NotNull GhostEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = pNetHeadYaw / 57.295776f;
        this.head.f_104203_ = pHeadPitch / 57.295776f;
        this.isAggressive = pEntity.m_5912_();
        if (pEntity.m_5912_()) {
            float f6 = Mth.m_14031_((float)(pLimbSwingAmount * (float)Math.PI));
            float f7 = Mth.m_14031_((float)((1.0f - (1.0f - pLimbSwingAmount) * (1.0f - pLimbSwingAmount)) * (float)Math.PI));
            this.right_arm.f_104204_ = -(0.1f - f6 * 0.6f);
            this.left_arm.f_104204_ = 0.1f - f6 * 0.6f;
            this.right_arm.f_104203_ = -1.5707964f;
            this.left_arm.f_104203_ = -1.5707964f;
            this.right_arm.f_104203_ -= f6 * 1.2f - f7 * 0.4f;
            this.left_arm.f_104203_ -= f6 * 1.2f - f7 * 0.4f;
            this.right_arm.f_104205_ += Mth.m_14089_((float)(pLimbSwing * 0.09f)) * 0.05f + 0.05f;
            this.left_arm.f_104205_ -= Mth.m_14089_((float)(pLimbSwing * 0.09f)) * 0.05f + 0.05f;
            this.right_arm.f_104203_ += Mth.m_14031_((float)(pLimbSwing * 0.067f)) * 0.05f;
            this.left_arm.f_104203_ -= Mth.m_14031_((float)(pLimbSwing * 0.067f)) * 0.05f;
        }
        float f3 = pAgeInTicks * 5.0f * ((float)Math.PI / 180);
        float f4 = Math.min(pLimbSwingAmount / 0.3f, 1.0f);
        float f5 = 1.0f - f4;
        this.body.f_104201_ += (float)Math.cos(f3) * 0.25f * f5;
    }

    public void setupAnim2(float pAgeInTicks) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        float f3 = pAgeInTicks * 5.0f * ((float)Math.PI / 180);
        this.body.f_104201_ += (float)Math.cos(f3) * 0.25f;
    }

    public void m_7695_(@NotNull PoseStack pPoseStack, @NotNull VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        if (!this.isAggressive) {
            pAlpha *= 0.5f;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        pPoseStack.m_252880_(0.0f, 1.5f, 0.0f);
        this.body.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        pPoseStack.m_85849_();
    }
}

