/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CandleStickBlock
extends AbstractCandleBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Boolean)state.m_61143_((Property)LIT) != false ? 6 : 0;
    private final Map<ResourceLocation, Supplier<Block>> fullHolderByContent = Maps.newHashMap();
    @Nullable
    private final Supplier<? extends Block> emptyBlock;
    @NotNull
    private final Supplier<Item> candle;

    protected CandleStickBlock(@Nullable Supplier<? extends Block> emptyBlock, @NotNull Supplier<Item> candle, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.emptyBlock = emptyBlock;
        this.candle = candle;
    }

    public void addCandle(ResourceLocation candle, Supplier<Block> holder) {
        if (candle == null) {
            throw new IllegalArgumentException("Cannot add plant to non-empty candle mount");
        }
        this.fullHolderByContent.put(candle, holder);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        Item item = stack.m_41720_();
        if (this.isEmpty()) {
            Block orDefault = this.fullHolderByContent.getOrDefault(ForgeRegistries.ITEMS.getKey((Object)item), () -> Blocks.f_50016_).get();
            if (orDefault != Blocks.f_50016_) {
                pLevel.m_7731_(pPos, this.getFilledState(pState, orDefault), 3);
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
        } else if (pPlayer.m_150110_().f_35938_ && pPlayer.m_21120_(pHand).m_41619_()) {
            if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
                CandleStickBlock.m_151899_((Player)pPlayer, (BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            if (this.emptyBlock != null) {
                pLevel.m_7731_(pPos, this.getEmptyState(pState, this.emptyBlock.get()), 3);
                if (!pPlayer.m_150110_().f_35937_) {
                    pPlayer.m_36356_(this.candle.get().m_7968_());
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected BlockState getFilledState(BlockState sourceState, Block block) {
        return (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)sourceState.m_61143_((Property)WATERLOGGED)))).m_61124_((Property)LIT, (Comparable)((Boolean)sourceState.m_61143_((Property)LIT)));
    }

    protected BlockState getEmptyState(BlockState sourceState, Block block) {
        return (BlockState)((BlockState)block.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)sourceState.m_61143_((Property)WATERLOGGED)))).m_61124_((Property)LIT, (Comparable)((Boolean)sourceState.m_61143_((Property)LIT)));
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @NotNull
    public FluidState m_5888_(@NotNull BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public boolean m_7361_(@NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            BlockState blockstate = (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
            if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
                CandleStickBlock.m_151899_((Player)null, (BlockState)blockstate, (LevelAccessor)pLevel, (BlockPos)pPos);
            } else {
                pLevel.m_7731_(pPos, blockstate, 3);
            }
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    protected boolean m_142595_(@NotNull BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) == false && !this.isEmpty() && super.m_142595_(pState);
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        return Block.m_49863_((LevelReader)pLevel, (BlockPos)pPos.m_7495_(), (Direction)Direction.UP);
    }

    public static boolean canLight(@NotNull BlockState pState) {
        return pState.m_204338_(BlockTags.f_144265_, p_152810_ -> p_152810_.m_61138_((Property)LIT) && p_152810_.m_61138_((Property)WATERLOGGED)) && (Boolean)pState.m_61143_((Property)LIT) == false && (Boolean)pState.m_61143_((Property)WATERLOGGED) == false;
    }

    public @NotNull Supplier<@Nullable Item> getCandle() {
        return this.candle;
    }

    public boolean isEmpty() {
        return this.candle.get() == null;
    }
}

