/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.network;

import de.teamlapen.lib.network.IMessage;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPacketDispatcher {
    protected final SimpleChannel dispatcher;
    private byte packetId = 0;

    protected AbstractPacketDispatcher(SimpleChannel channel) {
        this.dispatcher = channel;
    }

    public abstract void registerPackets();

    public final void sendTo(@NotNull IMessage.IClientBoundMessage message, ServerPlayer player) {
        Objects.requireNonNull(message);
        this.dispatcher.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public final void sendToAll(IMessage.IClientBoundMessage message) {
        this.dispatcher.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public final void sendToAllAround(IMessage.IClientBoundMessage message, ResourceKey<Level> dimension, double x, double y, double z, double range) {
        this.sendToAllAround(message, new PacketDistributor.TargetPoint(x, y, z, range, dimension));
    }

    public final void sendToAllAround(IMessage.IClientBoundMessage message, PacketDistributor.TargetPoint point) {
        this.dispatcher.send(PacketDistributor.NEAR.with(() -> point), (Object)message);
    }

    public final void sendToAllTrackingPlayers(IMessage.IClientBoundMessage message, Entity target) {
        this.dispatcher.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)message);
    }

    public final void sendToServer(IMessage.IServerBoundMessage message) {
        this.dispatcher.sendToServer((Object)message);
    }

    protected int nextID() {
        byte by = this.packetId;
        this.packetId = (byte)(by + 1);
        return by;
    }

    protected <MSG extends IMessage.IClientBoundMessage> void registerClientBound(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        this.dispatcher.messageBuilder(messageType, this.nextID(), NetworkDirection.PLAY_TO_CLIENT).encoder(encoder).decoder(decoder).consumerNetworkThread(messageConsumer).add();
    }

    protected <MSG extends IMessage.IServerBoundMessage> void registerServerBound(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        this.dispatcher.messageBuilder(messageType, this.nextID(), NetworkDirection.PLAY_TO_SERVER).encoder(encoder).decoder(decoder).consumerNetworkThread(messageConsumer).add();
    }
}

