/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.loader.index;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.CommonGunPackLoader;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.network.CommonGunPackNetwork;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.resource.pojo.AttachmentIndexPOJO;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class CommonAttachmentIndexLoader {
    private static final Pattern ATTACHMENT_INDEX_PATTERN = Pattern.compile("^(\\w+)/attachments/index/(\\w+)\\.json$");
    private static final Marker MARKER = MarkerManager.getMarker((String)"CommonAttachmentIndexLoader");

    public static void loadAttachmentIndex(String path, ZipFile zipFile) throws IOException {
        Matcher matcher = ATTACHMENT_INDEX_PATTERN.matcher(path);
        if (matcher.find()) {
            String namespace = matcher.group(1);
            String id = matcher.group(2);
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) {
                GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)path);
                return;
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                String json = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                ResourceLocation registryName = new ResourceLocation(namespace, id);
                CommonAttachmentIndexLoader.loadAttachmentFromJsonString(registryName, json);
                CommonGunPackNetwork.addData(DataType.ATTACHMENT_INDEX, registryName, json);
            }
            catch (JsonIOException | JsonSyntaxException | IllegalArgumentException exception) {
                GunMod.LOGGER.warn("{} index file read fail!", (Object)path);
                exception.printStackTrace();
            }
        }
    }

    public static void loadAttachmentIndex(File root) throws IOException {
        Path filePath = root.toPath().resolve("attachments/index");
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(filePath.toFile(), root.getName(), ".json", (id, file) -> {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    String json = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    CommonAttachmentIndexLoader.loadAttachmentFromJsonString(id, json);
                    CommonGunPackNetwork.addData(DataType.ATTACHMENT_INDEX, id, json);
                }
                catch (JsonIOException | JsonSyntaxException | IOException | IllegalArgumentException exception) {
                    GunMod.LOGGER.warn("{} index file read fail!", file);
                    exception.printStackTrace();
                }
            });
            Files.walkFileTree(filePath, visitor);
        }
    }

    public static void loadAttachmentFromJsonString(ResourceLocation id, String json) {
        AttachmentIndexPOJO indexPOJO = (AttachmentIndexPOJO)CommonGunPackLoader.GSON.fromJson(json, AttachmentIndexPOJO.class);
        CommonGunPackLoader.ATTACHMENT_INDEX.put(id, CommonAttachmentIndex.getInstance(id, indexPOJO));
    }
}

