/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.loader.asset;

import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.texture.FilePackTexture;
import com.tacz.guns.client.resource.texture.ZipPackTexture;
import com.tacz.guns.util.TacPathVisitor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class TextureLoader {
    private static final Marker MARKER = MarkerManager.getMarker((String)"TextureLoader");
    private static final Pattern TEXTURE_PATTERN = Pattern.compile("^(\\w+)/textures/([\\w/]+)\\.png$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = TEXTURE_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            String namespace = matcher.group(1);
            String path = matcher.group(2);
            ZipEntry entry = zipFile.getEntry(zipPath);
            if (entry == null) {
                GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                return false;
            }
            ResourceLocation id = new ResourceLocation(namespace, path);
            ZipPackTexture zipPackTexture = new ZipPackTexture(id, zipFile.getName());
            Minecraft.m_91087_().f_90987_.m_118495_(id, (AbstractTexture)zipPackTexture);
            return true;
        }
        return false;
    }

    public static void load(File root) {
        Path filePath = root.toPath().resolve("textures");
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(filePath.toFile(), root.getName(), ".png", (id, file) -> {
                FilePackTexture filePackTexture = new FilePackTexture((ResourceLocation)id, (Path)file);
                Minecraft.m_91087_().f_90987_.m_118495_(id, (AbstractTexture)filePackTexture);
            });
            try {
                Files.walkFileTree(filePath, visitor);
            }
            catch (Exception e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)filePath);
                e.printStackTrace();
            }
        }
    }
}

