/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.bedrock.ModelRendererWrapper;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.compat.oculus.OculusCompat;
import com.tacz.guns.util.RenderHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Vector3f;

public class BedrockAttachmentModel
extends BedrockAnimatedModel {
    private static final String SCOPE_VIEW_NODE = "scope_view";
    private static final String SCOPE_BODY_NODE = "scope_body";
    private static final String OCULAR_RING_NODE = "ocular_ring";
    private static final String DIVISION_NODE = "division";
    private static final String OCULAR_NODE = "ocular";
    @Nullable
    protected List<BedrockPart> scopeViewPath = this.getPath((ModelRendererWrapper)this.modelMap.get("scope_view"));
    @Nullable
    protected List<BedrockPart> scopeBodyPath = this.getPath((ModelRendererWrapper)this.modelMap.get("scope_body"));
    @Nullable
    protected List<BedrockPart> ocularRingPath = this.getPath((ModelRendererWrapper)this.modelMap.get("ocular_ring"));
    @Nullable
    protected List<BedrockPart> ocularNodePath = this.getPath((ModelRendererWrapper)this.modelMap.get("ocular"));
    @Nullable
    protected List<BedrockPart> divisionNodePath = this.getPath((ModelRendererWrapper)this.modelMap.get("division"));
    private boolean isScope = true;
    private boolean isSight = false;
    private float scopeViewRadiusModifier = 1.0f;

    public BedrockAttachmentModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(pojo, version);
        if (this.divisionNodePath != null) {
            this.divisionNodePath.get((int)(this.divisionNodePath.size() - 1)).visible = false;
        }
    }

    @Nullable
    public List<BedrockPart> getScopeViewPath() {
        return this.scopeViewPath;
    }

    public void setIsScope(boolean isScope) {
        if (isScope) {
            this.isSight = false;
        }
        this.isScope = isScope;
    }

    public void setIsSight(boolean isSight) {
        if (isSight) {
            this.isScope = false;
        }
        this.isSight = isSight;
    }

    public boolean isScope() {
        return this.isScope;
    }

    public boolean isSight() {
        return this.isSight;
    }

    public void setScopeViewRadiusModifier(float scopeViewRadiusModifier) {
        this.scopeViewRadiusModifier = scopeViewRadiusModifier;
    }

    @Override
    public void render(PoseStack matrixStack, ItemDisplayContext transformType, RenderType renderType, int light, int overlay) {
        if (transformType.m_269069_()) {
            if (this.isScope) {
                this.renderScope(matrixStack, transformType, renderType, light, overlay);
            } else if (this.isSight) {
                this.renderSight(matrixStack, transformType, renderType, light, overlay);
            }
        } else {
            if (this.scopeBodyPath != null) {
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
            }
            if (this.ocularRingPath != null) {
                this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularRingPath);
            }
        }
        super.render(matrixStack, transformType, renderType, light, overlay);
    }

    private void renderSight(PoseStack matrixStack, ItemDisplayContext transformType, RenderType renderType, int light, int overlay) {
        RenderHelper.enableItemEntityStencilTest();
        if (this.ocularNodePath != null) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.clearStencil((int)0);
            RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
            RenderSystem.stencilMask((int)255);
            RenderSystem.stencilFunc((int)519, (int)1, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePath);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (this.divisionNodePath != null) {
            RenderSystem.stencilFunc((int)514, (int)1, (int)255);
            RenderSystem.disableDepthTest();
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.divisionNodePath);
            RenderSystem.enableDepthTest();
        }
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderHelper.disableItemEntityStencilTest();
        if (this.scopeBodyPath != null) {
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
        }
        super.render(matrixStack, transformType, renderType, light, overlay);
    }

    private Vector3f getBedrockPartCenter(PoseStack poseStack, @Nonnull List<BedrockPart> path) {
        poseStack.m_85836_();
        for (BedrockPart part : path) {
            part.translateAndRotateAndScale(poseStack);
        }
        Vector3f result = new Vector3f(poseStack.m_85850_().m_252922_().m30(), poseStack.m_85850_().m_252922_().m31(), poseStack.m_85850_().m_252922_().m32());
        poseStack.m_85849_();
        return result;
    }

    private void renderTempPart(PoseStack poseStack, ItemDisplayContext transformType, RenderType renderType, int light, int overlay, @Nonnull List<BedrockPart> path) {
        poseStack.m_85836_();
        for (int i = 0; i < path.size() - 1; ++i) {
            path.get(i).translateAndRotateAndScale(poseStack);
        }
        BedrockPart part = path.get(path.size() - 1);
        part.visible = true;
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        part.render(poseStack, transformType, vertexConsumer, light, overlay);
        if (!OculusCompat.endBatch(bufferSource)) {
            bufferSource.m_109912_(renderType);
        }
        part.visible = false;
        poseStack.m_85849_();
    }

    private void renderScope(PoseStack matrixStack, ItemDisplayContext transformType, RenderType renderType, int light, int overlay) {
        RenderHelper.enableItemEntityStencilTest();
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
        if (this.ocularRingPath != null) {
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularRingPath);
        }
        if (this.ocularNodePath != null) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.stencilMask((int)255);
            RenderSystem.stencilFunc((int)519, (int)1, (int)255);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePath);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (this.scopeBodyPath != null) {
            RenderSystem.stencilFunc((int)517, (int)1, (int)255);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.scopeBodyPath);
        }
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7682);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        Vector3f ocularCenter = this.getBedrockPartCenter(matrixStack, this.ocularNodePath);
        float centerX = ocularCenter.x() * 16.0f * 90.0f;
        float centerY = ocularCenter.y() * 16.0f * 90.0f;
        float rad = 80.0f * this.scopeViewRadiusModifier;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            rad *= IClientPlayerGunOperator.fromLocalPlayer(player).getClientAimingProgress(Minecraft.m_91087_().m_91296_());
        }
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        builder.m_5483_((double)centerX, (double)centerY, -90.0).m_6122_(255, 255, 255, 255).m_5752_();
        for (int i = 0; i <= 90; ++i) {
            float angle = (float)i * ((float)Math.PI * 2) / 90.0f;
            float sin = Mth.m_14031_((float)angle);
            float cos = Mth.m_14089_((float)angle);
            builder.m_5483_((double)(centerX + cos * rad), (double)(centerY + sin * rad), -90.0).m_6122_(255, 255, 255, 255).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.ocularNodePath);
        if (this.divisionNodePath != null) {
            RenderSystem.stencilFunc((int)514, (int)2, (int)255);
            this.renderTempPart(matrixStack, transformType, renderType, light, overlay, this.divisionNodePath);
        }
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderHelper.disableItemEntityStencilTest();
        super.render(matrixStack, transformType, renderType, light, overlay);
    }
}

