/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerCrawl;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LocalPlayerCrawl {
    private static final int COOLDOWN_TICKS = 10;
    private final LocalPlayer player;
    private boolean isCrawling = false;
    private int crawCooldownTicks = 0;

    public LocalPlayerCrawl(LocalPlayer player) {
        this.player = player;
    }

    public void crawl(boolean isCrawl) {
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        if (this.crawCooldownTicks > 0) {
            return;
        }
        if (this.player.m_5833_() || this.player.m_20159_() || !this.player.m_20096_()) {
            return;
        }
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            this.isCrawling = isCrawl;
            this.crawCooldownTicks = 10;
            NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerCrawl(isCrawl));
        });
    }

    public void tickCrawl() {
        ItemStack mainhandItem;
        Item item;
        if (this.crawCooldownTicks > 0) {
            --this.crawCooldownTicks;
        }
        if (!((item = (mainhandItem = this.player.m_21205_()).m_41720_()) instanceof IGun)) {
            this.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        if (TimelessAPI.getCommonGunIndex(gunId).isEmpty()) {
            this.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        if (this.player.m_5833_() || this.player.m_20159_() || this.player.f_20899_ || this.player.m_6069_() || !this.player.m_20096_()) {
            this.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        this.setCrawlPose();
    }

    public boolean isCrawling() {
        return this.isCrawling;
    }

    private void setCrawlPose() {
        if (this.isCrawling) {
            this.player.setForcedPose(Pose.SWIMMING);
        } else {
            this.player.setForcedPose(null);
        }
    }
}

