/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.download;

import com.google.common.collect.Maps;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.gui.GunPackProgressScreen;
import com.tacz.guns.client.resource.ClientReloadManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.ProgressListener;
import net.minecraftforge.fml.ModList;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

public class ClientGunPackDownloader {
    private static final int MAX_FILE_SIZE = 0xFA00000;
    private final ReentrantLock downloadLock = new ReentrantLock();
    private final Path serverGunPackPath;
    @Nullable
    private CompletableFuture<?> currentDownload;

    public ClientGunPackDownloader(Path serverGunPackPath) {
        this.serverGunPackPath = serverGunPackPath;
    }

    private static Map<String, String> getDownloadHeaders() {
        HashMap map = Maps.newHashMap();
        User user = Minecraft.m_91087_().m_91094_();
        WorldVersion currentVersion = SharedConstants.m_183709_();
        map.put("X-Minecraft-Username", user.m_92546_());
        map.put("X-Minecraft-UUID", user.m_92545_());
        map.put("X-Minecraft-Version", currentVersion.m_132493_());
        map.put("X-Minecraft-Version-ID", currentVersion.m_132492_());
        map.put("X-TACZ-Version", ModList.get().getModFileById("tacz").versionString());
        map.put("User-Agent", "Minecraft Java/" + currentVersion.m_132493_());
        return map;
    }

    public CompletableFuture<?> downloadAndLoadGunPack(String plainUrl, String hash) {
        CompletableFuture<?> resultFuture;
        this.downloadLock.lock();
        try {
            CompletableFuture downloadFuture;
            this.clearDownloadingGunPack();
            File gunPack = this.serverGunPackPath.resolve(hash).toFile();
            this.removeMismatchFile(hash, gunPack);
            if (gunPack.exists()) {
                downloadFuture = CompletableFuture.completedFuture("");
            } else {
                GunPackProgressScreen progressScreen = new GunPackProgressScreen();
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.m_18709_(() -> minecraft.m_91152_((Screen)progressScreen));
                URL url = new URL(plainUrl);
                downloadFuture = HttpUtil.m_216225_((File)gunPack, (URL)url, ClientGunPackDownloader.getDownloadHeaders(), (int)0xFA00000, (ProgressListener)progressScreen, (Proxy)minecraft.m_91096_());
            }
            resultFuture = this.currentDownload = ((CompletableFuture)downloadFuture.thenCompose(target -> {
                if (this.notMatchHash(hash, gunPack)) {
                    return ClientGunPackDownloader.failedFuture(new RuntimeException("Hash check failure for file " + gunPack + ", see log"));
                }
                return this.loadClientGunPack(gunPack);
            })).whenComplete((target, throwable) -> this.afterFail((Throwable)throwable, gunPack));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.downloadLock.unlock();
        }
        return resultFuture;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable pTerminationException) {
        CompletableFuture completablefuture = new CompletableFuture();
        completablefuture.completeExceptionally(pTerminationException);
        return completablefuture;
    }

    private void afterFail(Throwable throwable, File gunPack) {
        if (throwable == null) {
            return;
        }
        GunMod.LOGGER.warn("Pack application failed: {}, deleting file {}", (Object)throwable.getMessage(), (Object)gunPack);
        try {
            Files.delete(gunPack.toPath());
        }
        catch (IOException exception) {
            GunMod.LOGGER.warn("Failed to delete file {}: {}", (Object)gunPack, (Object)exception.getMessage());
        }
        Minecraft.m_91087_().execute(() -> this.displayFailScreen(Minecraft.m_91087_()));
    }

    private void displayFailScreen(Minecraft mc) {
        MutableComponent title = Component.m_237115_((String)"gui.tacz.client_gun_pack_downloader.fail.title");
        MutableComponent subTitle = Component.m_237115_((String)"gui.tacz.client_gun_pack_downloader.fail.subtitle");
        Component yesButton = CommonComponents.f_130659_;
        MutableComponent noButton = Component.m_237115_((String)"menu.disconnect");
        mc.m_91152_((Screen)new ConfirmScreen(button -> {
            if (button) {
                mc.m_91152_(null);
            } else {
                ClientPacketListener clientpacketlistener = mc.m_91403_();
                if (clientpacketlistener != null) {
                    clientpacketlistener.m_104910_().m_129507_((Component)Component.m_237115_((String)"connect.aborted"));
                }
            }
        }, (Component)title, (Component)subTitle, yesButton, (Component)noButton));
    }

    public void clearDownloadingGunPack() {
        this.downloadLock.lock();
        try {
            if (this.currentDownload != null) {
                this.currentDownload.cancel(true);
            }
            this.currentDownload = null;
        }
        finally {
            this.downloadLock.unlock();
        }
    }

    public void removeMismatchFile(String expectedHash, File file) {
        if (file.exists() && this.notMatchHash(expectedHash, file)) {
            try {
                FileUtils.delete((File)file);
            }
            catch (IOException exception) {
                GunMod.LOGGER.warn("Failed to delete file {}: {}", (Object)file, (Object)exception.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean notMatchHash(String expectedHash, File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            String fileHash = DigestUtils.sha1Hex((InputStream)stream);
            if (fileHash.toLowerCase(Locale.US).equals(expectedHash.toLowerCase(Locale.US))) {
                GunMod.LOGGER.info("Found file {} matching requested fileHash {}", (Object)file, (Object)expectedHash);
                boolean bl = false;
                return bl;
            }
            GunMod.LOGGER.warn("File {} had wrong fileHash (expected {}, found {}).", (Object)file, (Object)expectedHash, (Object)fileHash);
            return true;
        }
        catch (IOException ioexception) {
            GunMod.LOGGER.warn("File {} couldn't be hashed.", (Object)file, (Object)ioexception);
        }
        return true;
    }

    public CompletableFuture<?> loadClientGunPack(File file) {
        ClientReloadManager.loadClientDownloadGunPack(file);
        return CompletableFuture.completedFuture("");
    }
}

