/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.modifier;

import com.google.common.collect.ImmutableList;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ParameterizedCache<T> {
    private final T defaultValue;
    private final List<String> scripts;
    private final double addend;
    private final double percent;
    private final double multiplier;

    public ParameterizedCache(List<Modifier> modifiers, T defaultValue) {
        double addend = 0.0;
        double percent = 1.0;
        double multiplier = 1.0;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Modifier mod : modifiers) {
            addend += mod.getAddend();
            percent += mod.getPercent();
            multiplier *= Math.max(mod.getMultiplier(), 0.0);
            if (!StringUtils.isNotEmpty((CharSequence)mod.getFunction())) continue;
            builder.add((Object)mod.getFunction());
        }
        this.addend = addend;
        this.percent = percent;
        this.multiplier = multiplier;
        this.scripts = builder.build();
        this.defaultValue = defaultValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public double eval(double input) {
        double percent = Math.max(this.percent, 0.0);
        double value = (input + this.addend) * percent * this.multiplier;
        for (String function : this.scripts) {
            if (StringUtils.isEmpty((CharSequence)function)) continue;
            value = AttachmentPropertyManager.functionEval(value, input, function);
        }
        return value;
    }

    public double eval(double input, double extraAddend, double extraPercent, double extraMultiplier) {
        double percent = Math.max(this.percent + extraPercent, 0.0);
        extraMultiplier = Math.max(extraMultiplier, 0.0);
        double value = (input + this.addend + extraAddend) * percent * this.multiplier * extraMultiplier;
        for (String function : this.scripts) {
            if (StringUtils.isEmpty((CharSequence)function)) continue;
            value = AttachmentPropertyManager.functionEval(value, input, function);
        }
        return value;
    }

    public static <T> ParameterizedCache<T> of(T defaultValue) {
        return new ParameterizedCache<T>(List.of(), defaultValue);
    }

    public static <T> ParameterizedCache<T> of(List<Modifier> modifiers, T defaultValue) {
        return new ParameterizedCache<T>(modifiers, defaultValue);
    }
}

