/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.wires.utils.IElectricDamageSource;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import blusunrize.immersiveengineering.mixin.accessors.DamageSourcesAccess;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class IEDamageSources {
    private static final IElectricEquipment.ElectricSource TC_LOW = new IElectricEquipment.ElectricSource(0.25f);
    private static final IElectricEquipment.ElectricSource TC_HIGH = new IElectricEquipment.ElectricSource(2.0f);

    public static DamageSource causeCasullDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_CASULL);
    }

    public static DamageSource causePiercingDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_ARMORPIERCING);
    }

    public static DamageSource causeBuckshotDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_BUCKSHOT);
    }

    public static DamageSource causeDragonsbreathDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_DRAGONSBREATH);
    }

    public static DamageSource causeHomingDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_HOMING);
    }

    public static DamageSource causeWolfpackDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_WOLFPACK);
    }

    public static DamageSource causeSilverDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_SILVER);
    }

    public static DamageSource causePotionDamage(RevolvershotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.REVOLVER_POTION);
    }

    public static DamageSource acid(Level level) {
        return IEDamageSources.sources(level).invokeSource(Lib.DamageTypes.ACID, null, null);
    }

    public static DamageSource crusher(Level level) {
        return IEDamageSources.sources(level).invokeSource(Lib.DamageTypes.CRUSHER, null, null);
    }

    public static DamageSource sawmill(Level level) {
        return IEDamageSources.sources(level).invokeSource(Lib.DamageTypes.SAWMILL, null, null);
    }

    public static DamageSource razorWire(Level level) {
        return IEDamageSources.sources(level).invokeSource(Lib.DamageTypes.RAZOR_WIRE, null, null);
    }

    public static DamageSource razorShock(Level level) {
        return IEDamageSources.sources(level).invokeSource(Lib.DamageTypes.RAZOR_SHOCK, null, null);
    }

    public static DamageSource wireShock(Level level) {
        return new ElectricDamageSource(IEDamageSources.typeHolder(level, Lib.DamageTypes.WIRE_SHOCK), new IElectricEquipment.ElectricSource(1.0f), 1.0f);
    }

    public static ElectricDamageSource causeTeslaDamage(Level level, float amount, boolean lowPower) {
        return new ElectricDamageSource(IEDamageSources.typeHolder(level, Lib.DamageTypes.TESLA), lowPower ? TC_LOW : TC_HIGH, amount);
    }

    public static ElectricDamageSource causeWireDamage(Level level, float amount, IElectricEquipment.ElectricSource source) {
        return new ElectricDamageSource(IEDamageSources.typeHolder(level, Lib.DamageTypes.WIRE_SHOCK), source, amount);
    }

    public static DamageSource causeRailgunDamage(RailgunShotEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.RAILGUN);
    }

    public static DamageSource causeSawbladeDamage(SawbladeEntity shot, Entity shooter) {
        return IEDamageSources.maybeTurret((Entity)shot, shooter, Lib.DamageTypes.SAWBLADE);
    }

    public static DamageSource causeTeslaPrimaryDamage(Level level) {
        return IEDamageSources.sources(level).invokeSource(Lib.DamageTypes.TESLA_PRIMARY, null, null);
    }

    private static DamageSource maybeTurret(Entity shot, @Nullable Entity shooter, Lib.TurretDamageType type) {
        if (shooter == null) {
            return IEDamageSources.sources(shot).invokeSource(type.turretType(), shot, null);
        }
        return IEDamageSources.sources(shot).invokeSource(type.playerType(), shot, shooter);
    }

    private static DamageSourcesAccess sources(Level level) {
        return (DamageSourcesAccess)level.m_269111_();
    }

    private static DamageSourcesAccess sources(Entity entity) {
        return IEDamageSources.sources(entity.m_9236_());
    }

    private static Holder<DamageType> typeHolder(Level level, ResourceKey<DamageType> typeKey) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
        return registry.m_246971_(typeKey);
    }

    public static class ElectricDamageSource
    extends DamageSource
    implements IElectricDamageSource {
        public IElectricEquipment.ElectricSource source;
        public float dmg;

        public ElectricDamageSource(Holder<DamageType> tag, IElectricEquipment.ElectricSource source, float amount) {
            super(tag);
            this.source = source;
            this.dmg = amount;
        }

        @Override
        public boolean apply(Entity e) {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                IElectricEquipment.applyToEntity(living, this, this.source);
            }
            if (this.dmg > 0.0f) {
                e.m_6469_((DamageSource)this, this.dmg);
            }
            return this.dmg > 0.0f;
        }

        @Override
        public float getDamage() {
            return this.dmg;
        }
    }
}

