/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import blusunrize.immersiveengineering.common.util.orientation.RotationUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class HammerItem
extends IEBaseItem {
    public HammerItem() {
        super(new Item.Properties().m_41499_(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return IEServerConfig.getOrDefault(IEServerConfig.TOOLS.hammerDurabiliy);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblocksAllowed", stack, "multiblockPermission");
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblockForbidden", stack, "multiblockInterdiction");
    }

    private void addInfo(List<Component> list, String titleKey, ItemStack stack, String nbtKey) {
        if (!ItemNBTHelper.hasKey(stack, nbtKey, 9)) {
            return;
        }
        MutableComponent title = Component.m_237115_((String)titleKey);
        ListTag tagList = stack.m_41784_().m_128437_(nbtKey, 8);
        if (!Screen.m_96638_()) {
            list.add((Component)title.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"desc.immersiveengineering.info.holdShift")));
        } else {
            list.add((Component)title);
            for (int i = 0; i < tagList.size(); ++i) {
                MultiblockHandler.IMultiblock multiblock;
                ResourceLocation mbName = ResourceLocation.m_135820_((String)tagList.m_128778_(i));
                if (mbName == null || (multiblock = MultiblockHandler.getByUniqueName(mbName)) == null) continue;
                list.add((Component)TextUtils.applyFormat(multiblock.getDisplayName(), ChatFormatting.DARK_GRAY));
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        IEBlockInterfaces.IHammerInteraction hammerInteraction;
        boolean rotate;
        ListTag list;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Direction side = context.m_43719_();
        List<ResourceLocation> permittedMultiblocks = null;
        List<ResourceLocation> interdictedMultiblocks = null;
        if (ItemNBTHelper.hasKey(stack, "multiblockPermission") && (permittedMultiblocks = HammerItem.parseMultiblockNames(list = stack.m_41784_().m_128437_("multiblockPermission", 8), player, "permission")) == null) {
            return InteractionResult.FAIL;
        }
        if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction") && (interdictedMultiblocks = HammerItem.parseMultiblockNames(list = stack.m_41784_().m_128437_("multiblockInterdiction", 8), player, "interdiction")) == null) {
            return InteractionResult.FAIL;
        }
        Direction multiblockSide = side.m_122434_() == Direction.Axis.Y && player != null ? Direction.m_122364_((double)player.m_146908_()).m_122424_() : side;
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            boolean isAllowed;
            if (!mb.isBlockTrigger(world.m_8055_(pos), multiblockSide, world) || !(isAllowed = permittedMultiblocks != null ? permittedMultiblocks.contains(mb.getUniqueName()) : (interdictedMultiblocks != null ? !interdictedMultiblocks.contains(mb.getUniqueName()) : true)) || MultiblockHandler.postMultiblockFormationEvent(player, mb, pos, stack).isCanceled() || !mb.createStructure(world, pos, multiblockSide, player)) continue;
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                IEAdvancements.TRIGGER_MULTIBLOCK.trigger(sPlayer, mb, stack);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof IEBlockInterfaces.IConfigurableSides) {
            Direction activeSide;
            IEBlockInterfaces.IConfigurableSides sideConfig = (IEBlockInterfaces.IConfigurableSides)tile;
            Direction direction = activeSide = player != null && player.m_6144_() ? side.m_122424_() : side;
            if (sideConfig.toggleSide(activeSide, player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        boolean bl = rotate = !(tile instanceof IEBlockInterfaces.IDirectionalBE) && !(tile instanceof IEBlockInterfaces.IHammerInteraction);
        if (!rotate && tile instanceof IEBlockInterfaces.IDirectionalBE) {
            IEBlockInterfaces.IDirectionalBE dirBE = (IEBlockInterfaces.IDirectionalBE)tile;
            rotate = dirBE.canHammerRotate(side, context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)pos)), (LivingEntity)player);
        }
        if (rotate && RotationUtil.rotateBlock(world, pos, player != null && player.m_6144_() != side.equals((Object)Direction.DOWN))) {
            return InteractionResult.SUCCESS;
        }
        if (!rotate && tile instanceof IEBlockInterfaces.IHammerInteraction && (hammerInteraction = (IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, context.m_43724_(), context.m_43720_())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static List<ResourceLocation> parseMultiblockNames(ListTag data, @Nullable Player player, String prefix) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (int i = 0; i < data.size(); ++i) {
            String listEntry = data.m_128778_(i);
            ResourceLocation asRL = ResourceLocation.m_135820_((String)listEntry);
            if (asRL == null || MultiblockHandler.getByUniqueName(asRL) == null) {
                if (player != null && !player.m_20193_().f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)("Invalid " + prefix + " entry: " + listEntry)), false);
                }
                return null;
            }
            result.add(asRL);
        }
        return result;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.m_41777_();
        if (container.m_220157_(1, ApiUtils.RANDOM_SOURCE, null)) {
            return ItemStack.f_41583_;
        }
        return container;
    }

    public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 14;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.m_44831_((ItemStack)book).keySet().stream().allMatch(enchantment -> this.canApplyAtEnchantingTable(stack, (Enchantment)enchantment));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44962_;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.m_204117_(Tags.Items.INGOTS_IRON);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!player.m_9236_().f_46443_ && RotationUtil.rotateEntity((Entity)entity, player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.isCorrectToolForDrops(stack, state)) {
            return 6.0f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(IETags.hammerHarvestable);
    }
}

