/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class VirtualLocation {
    public static Codec<VirtualLocation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.f_46427_.fieldOf("world").forGetter(virtualLocation -> virtualLocation.world), (App)Codec.INT.fieldOf("x").forGetter(virtualLocation -> virtualLocation.x), (App)Codec.INT.fieldOf("z").forGetter(virtualLocation -> virtualLocation.z), (App)Codec.INT.fieldOf("depth").forGetter(virtualLocation -> virtualLocation.depth)).apply((Applicative)instance, VirtualLocation::new));
    private final ResourceKey<Level> world;
    private final int x;
    private final int z;
    private final int depth;

    public VirtualLocation(ResourceKey<Level> world, int x, int z, int depth) {
        this.world = world;
        this.x = x;
        this.z = z;
        this.depth = depth;
    }

    public static CompoundTag toNbt(VirtualLocation virtualLocation) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("world", virtualLocation.world.m_135782_().toString());
        nbt.m_128405_("x", virtualLocation.x);
        nbt.m_128405_("z", virtualLocation.z);
        nbt.m_128405_("depth", virtualLocation.depth);
        return nbt;
    }

    public static VirtualLocation fromNbt(CompoundTag nbt) {
        return new VirtualLocation((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("world"))), nbt.m_128451_("x"), nbt.m_128451_("z"), nbt.m_128451_("depth"));
    }

    public static VirtualLocation fromLocation(Location location) {
        VirtualLocation virtualLocation = null;
        if (ModDimensions.isPocketDimension(location.world)) {
            Pocket pocket = DimensionalRegistry.getPocketDirectory(location.world).getPocketAt(location.pos);
            virtualLocation = pocket != null ? pocket.virtualLocation : null;
        } else if (ModDimensions.isLimboDimension((Level)location.getWorld())) {
            virtualLocation = new VirtualLocation(location.world, location.getX(), location.getZ(), DimensionalDoors.getConfig().getDungeonsConfig().maxDungeonDepth);
        } else if (location.getWorld() != null) {
            virtualLocation = new VirtualLocation(location.world, location.getX(), location.getY(), 5);
        }
        if (virtualLocation == null) {
            return new VirtualLocation((ResourceKey<Level>)Level.f_46428_, location.getX(), location.getZ(), 5);
        }
        return new VirtualLocation(location.getWorldId(), location.getX(), location.getZ(), virtualLocation.getDepth());
    }

    public Location projectToWorld(boolean acceptLimbo) {
        ServerLevel world = DimensionalDoors.getServer().m_129880_(this.world);
        if (!acceptLimbo && ModDimensions.isLimboDimension((Level)world)) {
            world = world.m_7654_().m_129783_();
        }
        float spread = DimensionalDoors.getConfig().getGeneralConfig().depthSpreadFactor * this.depth;
        int newX = (int)((double)this.x + (double)(spread * 2.0f) * (Math.random() - 0.5));
        int newZ = (int)((double)this.z + (double)(spread * 2.0f) * (Math.random() - 0.5));
        BlockPos pos = VirtualLocation.getTopPos((Level)world, newX, newZ).m_7494_();
        return new Location(world, pos);
    }

    public static BlockPos getTopPos(Level world, int x, int z) {
        int topHeight = world.m_6325_(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z)).m_5885_(Heightmap.Types.MOTION_BLOCKING, x, z);
        return new BlockPos(x, topHeight, z);
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("world", this.world).add("x", this.x).add("z", this.z).add("depth", this.depth).toString();
    }
}

