/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.feature;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredSupplier;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.FlowingFluid;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.fluid.ModFluids;
import org.dimdev.dimdoors.world.feature.forge.ModFeaturesPlacedImpl;

public final class ModFeatures {

    public static class Placed {
        public static final ResourceKey<PlacedFeature> SOLID_STATIC_ORE = Placed.of("solid_static_ore");
        public static final ResourceKey<PlacedFeature> DECAYED_BLOCK_ORE = Placed.of("decayed_block_ore");
        public static final ResourceKey<PlacedFeature> ETERNAL_FLUID_SPRING = Placed.of("eternal_fluid_spring");

        public static void bootstrap(BootstapContext<PlacedFeature> bootstapContext) {
            HolderGetter lookup = bootstapContext.m_255420_(Registries.f_256911_);
            bootstapContext.m_255272_(DECAYED_BLOCK_ORE, (Object)new PlacedFeature((Holder)lookup.m_255043_(Configured.DECAYED_BLOCK_ORE), List.of(CountPlacement.m_191628_((int)4), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)79)), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_())));
            bootstapContext.m_255272_(SOLID_STATIC_ORE, (Object)new PlacedFeature((Holder)lookup.m_255043_(Configured.SOLID_STATIC_ORE), List.of(CountPlacement.m_191628_((int)3), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)0), (VerticalAnchor)VerticalAnchor.m_158935_((int)79)), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_())));
            bootstapContext.m_255272_(ETERNAL_FLUID_SPRING, (Object)new PlacedFeature((Holder)lookup.m_255043_(Configured.ETERNAL_FLUID_SPRING), List.of(CountPlacement.m_191628_((int)3), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)0), (VerticalAnchor)VerticalAnchor.m_158930_((int)192)), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_())));
        }

        public static ResourceKey<PlacedFeature> of(String id) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)DimensionalDoors.id(id));
        }

        @SafeVarargs
        public static HolderSet<Block> holderSet(RegistrySupplier<Block> ... blocks) {
            return HolderSet.m_205800_(Stream.of(blocks).map(DeferredSupplier::getKey).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_246971_(arg_0)).toList());
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isDesert(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isDesert(context);
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isOcean(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isOcean(context);
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isEnd(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isEnd(context);
        }

        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static boolean isOverworld(BiomeModifications.BiomeContext context) {
            return ModFeaturesPlacedImpl.isOverworld(context);
        }
    }

    public static final class Configured {
        public static final ResourceKey<ConfiguredFeature<?, ?>> SOLID_STATIC_ORE = Configured.of("solid_static_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DECAYED_BLOCK_ORE = Configured.of("decayed_block_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> ETERNAL_FLUID_SPRING = Configured.of("eternal_fluid_spring");

        public static ResourceKey<ConfiguredFeature<?, ?>> of(String id) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)DimensionalDoors.id(id));
        }

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> bootstapContext) {
            bootstapContext.m_255272_(DECAYED_BLOCK_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)new BlockMatchTest((Block)ModBlocks.UNRAVELLED_FABRIC.get()), (BlockState)((Block)ModBlocks.DECAYED_BLOCK.get()).m_49966_())), 64, 0.0f)));
            bootstapContext.m_255272_(SOLID_STATIC_ORE, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)new BlockMatchTest((Block)ModBlocks.UNRAVELLED_FABRIC.get()), (BlockState)((Block)ModBlocks.SOLID_STATIC.get()).m_49966_())), 4, 0.0f)));
            bootstapContext.m_255272_(ETERNAL_FLUID_SPRING, (Object)new ConfiguredFeature(Feature.f_65765_, (FeatureConfiguration)new SpringConfiguration(((FlowingFluid)ModFluids.ETERNAL_FLUID.get()).m_76145_(), true, 1, 4, Placed.holderSet(ModBlocks.UNRAVELLED_FABRIC, ModBlocks.UNRAVELLED_BLOCK, ModBlocks.UNFOLDED_BLOCK, ModBlocks.UNWARPED_BLOCK))));
        }
    }
}

