/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import java.util.UUID;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.rift.targets.LimboTarget;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;

public class PrivatePocketExitTarget
extends VirtualTarget
implements EntityTarget {
    public static final PrivatePocketExitTarget INSTANCE = new PrivatePocketExitTarget();
    public static final RGBA COLOR = new RGBA(0.0f, 1.0f, 0.0f, 1.0f);

    private PrivatePocketExitTarget() {
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 relativeVelocity, Location location) {
        UUID uuid = EntityUtils.getOwner(entity).m_20148_();
        if (uuid != null) {
            Location destLoc = DimensionalRegistry.getRiftRegistry().getPrivatePocketExit(uuid);
            PrivatePocket pocket = DimensionalRegistry.getPrivateRegistry().getPrivatePocket(uuid);
            if (ModDimensions.isPrivatePocketDimension((Level)this.location.getWorld()) && pocket != null && DimensionalRegistry.getPocketDirectory(pocket.getWorld()).getPocketAt(this.location.pos).equals(pocket)) {
                DimensionalRegistry.getRiftRegistry().setLastPrivatePocketEntrance(uuid, this.location);
            }
            if (destLoc == null || !(destLoc.getBlockEntity() instanceof RiftBlockEntity)) {
                if (destLoc == null) {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.private_pocket_exit.did_not_use_rift"));
                } else {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.private_pocket_exit.rift_has_closed"));
                }
                LimboTarget.INSTANCE.receiveEntity(entity, relativePos, relativeAngle, relativeVelocity, location);
                return false;
            }
            ((EntityTarget)destLoc.getBlockEntity()).receiveEntity(entity, relativePos, relativeAngle, relativeVelocity, location);
            return true;
        }
        return false;
    }

    @Override
    public void register() {
        super.register();
        PocketDirectory privatePocketRegistry = DimensionalRegistry.getPocketDirectory(this.location.world);
        Pocket pocket = privatePocketRegistry.getPocketAt(this.location.pos);
        DimensionalRegistry.getRiftRegistry().addPocketEntrance(pocket, this.location);
    }

    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.PRIVATE_POCKET_EXIT.get();
    }

    @Override
    public VirtualTarget copy() {
        return this;
    }
}

