/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.virtual.reference;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.ResourceManager;
import org.dimdev.dimdoors.api.util.WeightedList;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.virtual.ImplementedVirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.reference.PocketGeneratorReference;

public class TagReference
extends PocketGeneratorReference {
    public static final String KEY = "tag";
    private final List<String> required = new ArrayList<String>();
    private final List<String> blackList = new ArrayList<String>();
    private Boolean exact;
    private WeightedList<PocketGenerator, PocketGenerationContext> pockets;

    @Override
    public ImplementedVirtualPocket fromNbt(CompoundTag nbt, ResourceManager manager) {
        int i;
        ListTag listNbt;
        super.fromNbt(nbt, manager);
        if (nbt.m_128441_("required")) {
            listNbt = nbt.m_128437_("required", 8);
            for (i = 0; i < listNbt.size(); ++i) {
                this.required.add(listNbt.m_128778_(i));
            }
        }
        if (nbt.m_128441_("blackList")) {
            listNbt = nbt.m_128437_("blackList", 8);
            for (i = 0; i < listNbt.size(); ++i) {
                this.blackList.add(listNbt.m_128778_(i));
            }
        }
        if (nbt.m_128441_("exact")) {
            this.exact = nbt.m_128471_("exact");
        }
        return this;
    }

    @Override
    protected CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        if (this.required.size() > 0) {
            ListTag listNbt = new ListTag();
            for (String nbtStr : this.required) {
                listNbt.add((Object)StringTag.m_129297_((String)nbtStr));
            }
            nbt.m_128365_("required", (Tag)listNbt);
        }
        if (this.blackList.size() > 0) {
            ListTag list = new ListTag();
            for (String nbtStr : this.blackList) {
                list.add((Object)StringTag.m_129297_((String)nbtStr));
            }
            nbt.m_128365_("blackList", (Tag)list);
        }
        if (this.exact != null) {
            nbt.m_128379_("exact", this.exact.booleanValue());
        }
        return nbt;
    }

    @Override
    public ImplementedVirtualPocket.VirtualPocketType<? extends ImplementedVirtualPocket> getType() {
        return (ImplementedVirtualPocket.VirtualPocketType)ImplementedVirtualPocket.VirtualPocketType.TAG_REFERENCE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PocketGenerator peekReferencedPocketGenerator(PocketGenerationContext parameters) {
        return this.selectPocket(parameters);
    }

    @Override
    public PocketGenerator getReferencedPocketGenerator(PocketGenerationContext parameters) {
        return this.selectPocket(parameters);
    }

    private PocketGenerator selectPocket(PocketGenerationContext parameters) {
        if (this.pockets == null) {
            this.pockets = PocketLoader.getInstance().getPocketsMatchingTags(this.required, this.blackList, this.exact != null && this.exact != false);
        }
        return this.pockets.peekNextRandomWeighted(parameters);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("weight", (Object)this.weight).add("weightEquation", (Object)this.weightEquation).add("setupLoot", (Object)this.setupLoot).add("modifierList", (Object)this.modifierList).add("required", this.required).add("blackList", this.blackList).add("exact", (Object)this.exact).add("pockets", this.pockets).toString();
    }
}

