/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class OffsetModifier
extends AbstractModifier {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "offset";
    private String offsetX;
    private Equation offsetXEquation;
    private String offsetY;
    private Equation offsetYEquation;
    private String offsetZ;
    private Equation offsetZEquation;

    @Override
    public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
        try {
            this.offsetX = nbt.m_128441_("offset_x") ? nbt.m_128461_("offset_x") : "0";
            this.offsetXEquation = Equation.parse(this.offsetX);
            this.offsetY = nbt.m_128441_("offset_y") ? nbt.m_128461_("offset_y") : "0";
            this.offsetYEquation = Equation.parse(this.offsetY);
            this.offsetZ = nbt.m_128441_("offset_z") ? nbt.m_128461_("offset_z") : "0";
            this.offsetZEquation = Equation.parse(this.offsetZ);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error((Object)e);
        }
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        if (!this.offsetX.equals("0")) {
            nbt.m_128359_("offset_x", this.offsetX);
        }
        if (!this.offsetY.equals("0")) {
            nbt.m_128359_("offset_y", this.offsetY);
        }
        if (!this.offsetZ.equals("0")) {
            nbt.m_128359_("offset_z", this.offsetZ);
        }
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.OFFSET_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        builder.offsetOrigin(new Vec3i((int)this.offsetXEquation.apply(variableMap), (int)this.offsetYEquation.apply(variableMap), (int)this.offsetZEquation.apply(variableMap)));
    }
}

