/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class PocketTemplate {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean replacingPlaceholders = false;
    private final Schematic schematic;
    private final ResourceLocation id;

    public PocketTemplate(Schematic schematic, ResourceLocation id) {
        this.schematic = schematic;
        this.id = id;
    }

    public void place(Pocket pocket, BlockPlacementType placementType) {
        pocket.setSize(this.schematic.getWidth(), this.schematic.getHeight(), this.schematic.getLength());
        ServerLevel world = DimensionalDoors.getWorld(pocket.getWorld());
        BlockPos origin = pocket.getOrigin();
        SchematicPlacer.place(this.schematic, (WorldGenLevel)world, origin, placementType);
    }

    public Map<BlockPos, RiftBlockEntity> getAbsoluteRifts(Pocket pocket) {
        pocket.setSize(this.schematic.getWidth(), this.schematic.getHeight(), this.schematic.getLength());
        Map<BlockPos, RiftBlockEntity> absoluteRifts = SchematicPlacer.getAbsoluteRifts(this.schematic, pocket.getOrigin());
        ServerLevel world = DimensionalDoors.getWorld(pocket.getWorld());
        absoluteRifts.values().forEach(rift -> rift.setWorld((Level)world));
        return absoluteRifts;
    }

    public void place(LazyGenerationPocket pocket, ChunkAccess chunk, BlockPos originalOrigin, BlockPlacementType placementType) {
        SchematicPlacer.place(this.schematic, DimensionalDoors.getWorld(pocket.getWorld()), chunk, originalOrigin, placementType);
    }

    public static boolean isReplacingPlaceholders() {
        return false;
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

