/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.particle.client;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import org.dimdev.dimdoors.particle.ModParticleTypes;

public record RiftParticleOptions(float color, int averageAge) implements ParticleOptions
{
    private static final RiftParticleOptions OUTSIDE = new RiftParticleOptions(0.4f, 2000);
    private static final RiftParticleOptions INSIDE = new RiftParticleOptions(0.8f, 2000);
    private static final RiftParticleOptions OUTSIDE_UNSTABLE = new RiftParticleOptions(0.0f, 2000);
    private static final RiftParticleOptions INSIDE_UNSTABLE = new RiftParticleOptions(0.7f, 2000);
    private static final RiftParticleOptions OUTSIDE_STABLE = new RiftParticleOptions(0.0f, 750);
    private static final RiftParticleOptions INSIDE_STABLE = new RiftParticleOptions(0.7f, 750);
    public static final Codec<RiftParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("color").forGetter(riftParticleEffect -> Float.valueOf(riftParticleEffect.color)), (App)Codec.INT.fieldOf("averageAge").forGetter(riftParticleEffect -> riftParticleEffect.averageAge)).apply((Applicative)instance, RiftParticleOptions::new));
    public static final ParticleOptions.Deserializer<RiftParticleOptions> PARAMETERS_FACTORY = new ParticleOptions.Deserializer<RiftParticleOptions>(){

        public RiftParticleOptions fromCommand(ParticleType<RiftParticleOptions> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float f = stringReader.readFloat();
            stringReader.expect(' ');
            int g = stringReader.readInt();
            return new RiftParticleOptions(f, g);
        }

        public RiftParticleOptions fromNetwork(ParticleType<RiftParticleOptions> particleType, FriendlyByteBuf packetByteBuf) {
            return new RiftParticleOptions(packetByteBuf.readFloat(), packetByteBuf.readInt());
        }
    };

    public static RiftParticleOptions of(boolean isOutsidePocket) {
        return isOutsidePocket ? OUTSIDE : INSIDE;
    }

    public static RiftParticleOptions of(boolean isOutsidePocket, boolean stablized) {
        if (isOutsidePocket) {
            if (stablized) {
                return OUTSIDE_STABLE;
            }
            return OUTSIDE_UNSTABLE;
        }
        if (stablized) {
            return INSIDE_STABLE;
        }
        return INSIDE_UNSTABLE;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.color);
        buf.writeInt(this.averageAge);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color), this.averageAge);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.RIFT.get();
    }
}

