/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.RotatedLocation;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.ModDimensions;

public class RiftSignatureItem
extends Item {
    public static final String ID = "rift_signature";
    public boolean shouldclear;

    public RiftSignatureItem(Item.Properties settings, boolean clear) {
        super(settings);
        this.shouldclear = clear;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128441_("destination");
    }

    public InteractionResult m_6225_(UseOnContext itemUsageContext) {
        Player player = itemUsageContext.m_43723_();
        Level world = itemUsageContext.m_43725_();
        BlockPos pos = itemUsageContext.m_8083_();
        InteractionHand hand = itemUsageContext.m_43724_();
        BlockState state = world.m_8055_(pos);
        Direction side = itemUsageContext.m_43719_();
        ItemStack stack = player.m_21120_(hand);
        PlacementLogic placedRiftLogic = PlacementLogic.getLogic(world, pos);
        if (placedRiftLogic == null) {
            pos = pos.m_121945_(side);
            placedRiftLogic = PlacementLogic.getLogic(world, pos);
        }
        if (!player.m_36204_(pos, side.m_122424_(), stack) || placedRiftLogic == null) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (ModDimensions.isPrivatePocketDimension(world) && !DimensionalDoors.getConfig().getPocketsConfig().canUseRiftSignatureInPrivatePockets) {
            player.m_5661_((Component)Component.m_237115_((String)"tools.signature_blocked").m_130940_(ChatFormatting.BLACK), true);
            return InteractionResult.FAIL;
        }
        RotatedLocation target = RiftSignatureItem.getSource(stack);
        if (target == null) {
            RiftSignatureItem.setSource(stack, new RotatedLocation((ResourceKey<Level>)world.m_46472_(), pos, player.m_146908_(), 0.0f));
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".stored")), true);
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.RIFT_START.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        } else {
            RotatedLocation source = new RotatedLocation((ResourceKey<Level>)world.m_46472_(), pos, player.m_146908_(), 0.0f);
            if (placedRiftLogic != null) {
                placedRiftLogic.getRift((ServerLevel)world, pos).ifPresent(a -> a.setDestination(RiftReference.tryMakeRelative(source, target)));
            }
            if ((placedRiftLogic = PlacementLogic.getLogic((Level)target.getWorld(), target.pos)) != null) {
                placedRiftLogic.getRift(target.getWorld(), target.pos).ifPresent(a -> a.setDestination(RiftReference.tryMakeRelative(target, source)));
            }
            stack.m_41622_(1, (LivingEntity)player, a -> {});
            if (this.shouldclear) {
                RiftSignatureItem.clearSource(stack);
            }
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".created")), true);
            world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.RIFT_END.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public static void setSource(ItemStack itemStack, RotatedLocation destination) {
        if (!itemStack.m_41782_()) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128365_("destination", (Tag)RotatedLocation.serialize(destination));
    }

    public static void clearSource(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            itemStack.m_41783_().m_128473_("destination");
        }
    }

    public static RotatedLocation getSource(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("destination")) {
            return RotatedLocation.deserialize(itemStack.m_41783_().m_128469_("destination"));
        }
        return null;
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag tooltipContext) {
        RotatedLocation transform = RiftSignatureItem.getSource(itemStack);
        if (transform != null) {
            list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".bound.info0"), (Object[])new Object[]{transform.getX(), transform.getY(), transform.getZ(), transform.getWorldId().m_135782_()}));
            list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".bound.info1"), (Object[])new Object[]{transform.getWorldId().m_135782_()}));
        } else {
            ToolTipHelper.processTranslation(list, this.m_5524_() + ".unbound.info", new Object[0]);
        }
    }

    public static enum PlacementLogic {
        CREATE((world, pos) -> {
            world.m_46597_(pos, ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
            DetachedRiftBlockEntity rift2 = (DetachedRiftBlockEntity)world.m_7702_(pos);
            rift2.register();
            return Optional.of(rift2);
        }),
        EXISTING((serverLevel, blockPos) -> {
            Optional optional;
            BlockState state = serverLevel.m_8055_(blockPos);
            Block patt0$temp = state.m_60734_();
            if (patt0$temp instanceof RiftProvider) {
                RiftProvider provider = (RiftProvider)patt0$temp;
                optional = Optional.ofNullable(provider.getRift((Level)serverLevel, (BlockPos)blockPos, state));
            } else {
                optional = Optional.empty();
            }
            return optional;
        }),
        DOOR((serverLevel, blockPos) -> {
            BlockState state = serverLevel.m_8055_(blockPos);
            Block patt0$temp = state.m_60734_();
            if (patt0$temp instanceof DoorBlock) {
                DoorBlock door = (DoorBlock)patt0$temp;
                Object patt1$temp = BuiltInRegistries.f_256975_.m_7745_(DimensionalDoors.getDimensionalDoorBlockRegistrar().get(door.arch$registryName()));
                if (patt1$temp instanceof DimensionalDoorBlock) {
                    DimensionalDoorBlock dimensionalDoorBlock = (DimensionalDoorBlock)patt1$temp;
                    BlockState dimdoorState = (BlockState)((BlockState)((BlockState)((BlockState)dimensionalDoorBlock.m_49966_().m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_)))).m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)state.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52729_, (Comparable)((Boolean)state.m_61143_((Property)DoorBlock.f_52727_)));
                    BlockPos top = state.m_61143_((Property)DimensionalDoorBlock.f_52730_) == DoubleBlockHalf.UPPER ? blockPos : blockPos.m_7494_();
                    BlockPos bottom = top.m_7495_();
                    serverLevel.m_46597_(top, (BlockState)((BlockState)dimdoorState.m_61124_((Property)DimensionalDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)DimensionalDoorBlock.WATERLOGGED, (Comparable)((Boolean)serverLevel.m_8055_(top).m_61143_((Property)DimensionalDoorBlock.WATERLOGGED))));
                    serverLevel.m_46597_(bottom, (BlockState)((BlockState)dimdoorState.m_61124_((Property)DimensionalDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)DimensionalDoorBlock.WATERLOGGED, (Comparable)((Boolean)serverLevel.m_8055_(bottom).m_61143_((Property)DimensionalDoorBlock.WATERLOGGED))));
                    return Optional.ofNullable(((RiftProvider)serverLevel.m_7702_(bottom)).getRift((Level)serverLevel, bottom, serverLevel.m_8055_(bottom)));
                }
            }
            return Optional.empty();
        });

        private BiFunction<ServerLevel, BlockPos, Optional<RiftBlockEntity>> function;

        private PlacementLogic(BiFunction<ServerLevel, BlockPos, Optional<RiftBlockEntity>> function) {
            this.function = function;
        }

        public Optional<RiftBlockEntity> getRift(ServerLevel world, BlockPos pos) {
            return this.function.apply(world, pos);
        }

        public static PlacementLogic getLogic(Level world, BlockPos pos) {
            BlockState state = world.m_8055_(pos);
            if (state.m_247087_()) {
                return CREATE;
            }
            if (state.m_60734_() instanceof RiftProvider) {
                return EXISTING;
            }
            if (state.m_60734_() instanceof DoorBlock) {
                return DOOR;
            }
            return null;
        }
    }
}

