/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block;

import dev.architectury.core.block.ArchitecturyLiquidBlock;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.block.AncientFabricBlock;
import org.dimdev.dimdoors.block.DetachedRiftBlock;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.EternalFluidBlock;
import org.dimdev.dimdoors.block.FabricBlock;
import org.dimdev.dimdoors.block.LimboAirBlock;
import org.dimdev.dimdoors.block.RealitySpongeBlock;
import org.dimdev.dimdoors.block.TesselatingLoomBlock;
import org.dimdev.dimdoors.block.UnravelledFabricBlock;
import org.dimdev.dimdoors.block.door.DimensionalTrapdoorBlock;
import org.dimdev.dimdoors.fluid.ModFluids;
import org.dimdev.dimdoors.item.ModItems;

public final class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"dimdoors", (ResourceKey)Registries.f_256747_);
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((String)"dimdoors", (ResourceKey)Registries.f_256913_);
    public static final Map<DyeColor, RegistrySupplier<Block>> FABRIC_BLOCKS = new HashMap<DyeColor, RegistrySupplier<Block>>();
    private static final Map<DyeColor, RegistrySupplier<Block>> ANCIENT_FABRIC_BLOCKS = new HashMap<DyeColor, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> STONE_PLAYER = ModBlocks.registerWithoutTabOrItem("stone_player", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(0.5f).m_60955_()));
    public static final RegistrySupplier<Block> GOLD_DOOR = ModBlocks.register("gold_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50074_).m_60978_(5.0f).m_60999_(), BlockSetType.f_271208_));
    public static final RegistrySupplier<Block> STONE_DOOR = ModBlocks.register("stone_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283825_).m_60978_(5.0f).m_60999_(), BlockSetType.f_271132_));
    public static final RegistrySupplier<Block> QUARTZ_DOOR = ModBlocks.register("quartz_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50333_).m_60978_(5.0f).m_60999_(), BlockSetType.f_271132_));
    public static final RegistrySupplier<Block> OAK_DIMENSIONAL_TRAPDOOR = ModBlocks.registerWithoutTabOrItem("wood_dimensional_trapdoor", () -> new DimensionalTrapdoorBlock(ModBlocks.of(Blocks.f_50216_).m_60953_(state -> 10), BlockSetType.f_271198_));
    public static final RegistrySupplier<Block> DIMENSIONAL_PORTAL = ModBlocks.registerWithoutTab("dimensional_portal", () -> new DimensionalPortalBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_222994_().m_60913_(-1.0f, 3600000.0f).m_60955_().m_60916_(Blocks.f_50016_).m_60953_(blockState -> 10)));
    public static final RegistrySupplier<Block> DETACHED_RIFT = ModBlocks.registerWithoutTabOrItem("detached_rift", () -> new DetachedRiftBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_222994_().m_284180_(MapColor.f_283927_).m_60913_(-1.0f, 3600000.0f).m_60910_().m_60955_()));
    public static final RegistrySupplier<Block> WHITE_FABRIC = ModBlocks.registerFabric(DyeColor.WHITE);
    public static final RegistrySupplier<Block> ORANGE_FABRIC = ModBlocks.registerFabric(DyeColor.ORANGE);
    public static final RegistrySupplier<Block> MAGENTA_FABRIC = ModBlocks.registerFabric(DyeColor.MAGENTA);
    public static final RegistrySupplier<Block> LIGHT_BLUE_FABRIC = ModBlocks.registerFabric(DyeColor.LIGHT_BLUE);
    public static final RegistrySupplier<Block> YELLOW_FABRIC = ModBlocks.registerFabric(DyeColor.YELLOW);
    public static final RegistrySupplier<Block> LIME_FABRIC = ModBlocks.registerFabric(DyeColor.LIME);
    public static final RegistrySupplier<Block> PINK_FABRIC = ModBlocks.registerFabric(DyeColor.PINK);
    public static final RegistrySupplier<Block> GRAY_FABRIC = ModBlocks.registerFabric(DyeColor.GRAY);
    public static final RegistrySupplier<Block> LIGHT_GRAY_FABRIC = ModBlocks.registerFabric(DyeColor.LIGHT_GRAY);
    public static final RegistrySupplier<Block> CYAN_FABRIC = ModBlocks.registerFabric(DyeColor.CYAN);
    public static final RegistrySupplier<Block> PURPLE_FABRIC = ModBlocks.registerFabric(DyeColor.PURPLE);
    public static final RegistrySupplier<Block> BLUE_FABRIC = ModBlocks.registerFabric(DyeColor.BLUE);
    public static final RegistrySupplier<Block> BROWN_FABRIC = ModBlocks.registerFabric(DyeColor.BROWN);
    public static final RegistrySupplier<Block> GREEN_FABRIC = ModBlocks.registerFabric(DyeColor.GREEN);
    public static final RegistrySupplier<Block> RED_FABRIC = ModBlocks.registerFabric(DyeColor.RED);
    public static final RegistrySupplier<Block> BLACK_FABRIC = ModBlocks.registerFabric(DyeColor.BLACK);
    public static final RegistrySupplier<Block> WHITE_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.WHITE);
    public static final RegistrySupplier<Block> ORANGE_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.ORANGE);
    public static final RegistrySupplier<Block> MAGENTA_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.MAGENTA);
    public static final RegistrySupplier<Block> LIGHT_BLUE_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.LIGHT_BLUE);
    public static final RegistrySupplier<Block> YELLOW_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.YELLOW);
    public static final RegistrySupplier<Block> LIME_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.LIME);
    public static final RegistrySupplier<Block> PINK_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.PINK);
    public static final RegistrySupplier<Block> GRAY_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.GRAY);
    public static final RegistrySupplier<Block> LIGHT_GRAY_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.LIGHT_GRAY);
    public static final RegistrySupplier<Block> CYAN_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.CYAN);
    public static final RegistrySupplier<Block> PURPLE_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.PURPLE);
    public static final RegistrySupplier<Block> BLUE_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.BLUE);
    public static final RegistrySupplier<Block> BROWN_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.BROWN);
    public static final RegistrySupplier<Block> GREEN_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.GREEN);
    public static final RegistrySupplier<Block> RED_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.RED);
    public static final RegistrySupplier<Block> BLACK_ANCIENT_FABRIC = ModBlocks.registerAncientFabric(DyeColor.BLACK);
    private static final BlockBehaviour.Properties UNRAVELLED_FABRIC_BLOCK_SETTINGS = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283927_).m_60977_().m_60953_(state -> 15).m_60913_(0.3f, 0.3f);
    public static final RegistrySupplier<LiquidBlock> ETERNAL_FLUID = ModBlocks.registerWithoutTabOrItem("eternal_fluid", () -> new EternalFluidBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49991_).m_284180_(MapColor.f_283913_).m_60953_(state -> 15)));
    public static final RegistrySupplier<LiquidBlock> LEAK = ModBlocks.registerWithoutTabOrItem("leak", () -> new ArchitecturyLiquidBlock(ModFluids.LEAK, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    public static final RegistrySupplier<Block> DECAYED_BLOCK = ModBlocks.registerWithoutTabOrItem("decayed_block", () -> new UnravelledFabricBlock(UNRAVELLED_FABRIC_BLOCK_SETTINGS));
    public static final RegistrySupplier<Block> UNFOLDED_BLOCK = ModBlocks.registerWithoutTabOrItem("unfolded_block", () -> new UnravelledFabricBlock(UNRAVELLED_FABRIC_BLOCK_SETTINGS));
    public static final RegistrySupplier<Block> UNWARPED_BLOCK = ModBlocks.registerWithoutTabOrItem("unwarped_block", () -> new UnravelledFabricBlock(UNRAVELLED_FABRIC_BLOCK_SETTINGS));
    public static final RegistrySupplier<Block> UNRAVELLED_BLOCK = ModBlocks.registerWithoutTabOrItem("unravelled_block", () -> new UnravelledFabricBlock(UNRAVELLED_FABRIC_BLOCK_SETTINGS));
    public static final RegistrySupplier<Block> UNRAVELLED_FABRIC = ModBlocks.register("unravelled_fabric", () -> new UnravelledFabricBlock(UNRAVELLED_FABRIC_BLOCK_SETTINGS));
    public static final RegistrySupplier<Block> MARKING_PLATE = ModBlocks.registerWithoutTabOrItem("marking_plate", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284268_(DyeColor.BLACK).m_60955_()));
    public static final RegistrySupplier<Block> SOLID_STATIC = ModBlocks.register("solid_static", () -> new UnravelledFabricBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(7.0f, 25.0f).m_60977_().m_60999_().m_60918_(SoundType.f_56746_)));
    public static final RegistrySupplier<Block> TESSELATING_LOOM = ModBlocks.register("tesselating_loom", () -> new TesselatingLoomBlock(ModBlocks.of(Blocks.f_50617_)));
    public static final RegistrySupplier<Block> REALITY_SPONGE = ModBlocks.register("reality_sponge", () -> new RealitySpongeBlock(UNRAVELLED_FABRIC_BLOCK_SETTINGS));
    public static final RegistrySupplier<Block> LIMBO_AIR = ModBlocks.registerWithoutTabOrItem("limbo_air", () -> new LimboAirBlock(BlockBehaviour.Properties.m_284310_().m_60977_().m_280170_().m_60910_().m_222994_().m_60996_()));
    public static final RegistrySupplier<Block> DRIFTWOOD_WOOD = ModBlocks.registerDecay("driftwood_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_284180_(MapColor.f_283779_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> DRIFTWOOD_LOG = ModBlocks.registerDecay("driftwood_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_284180_(MapColor.f_283779_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> DRIFTWOOD_PLANKS = ModBlocks.registerDecay("driftwood_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_284180_(MapColor.f_283779_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> DRIFTWOOD_LEAVES = ModBlocks.registerDecay("driftwood_leaves", () -> new LeavesBlock(ModBlocks.of(Blocks.f_50050_)));
    public static final RegistrySupplier<Block> DRIFTWOOD_SAPLING = ModBlocks.registerDecay("driftwood_sapling", () -> new Block(ModBlocks.of(Blocks.f_50746_)));
    public static final RegistrySupplier<Block> DRIFTWOOD_FENCE = ModBlocks.registerFence("driftwood_fence", DRIFTWOOD_PLANKS);
    public static final RegistrySupplier<Block> DRIFTWOOD_GATE = ModBlocks.registerFenceGate("driftwood_gate", DRIFTWOOD_PLANKS);
    public static final RegistrySupplier<Block> DRIFTWOOD_BUTTON = ModBlocks.registerButton("driftwood_button", DRIFTWOOD_PLANKS);
    public static final RegistrySupplier<Block> DRIFTWOOD_SLAB = ModBlocks.registerSlab("driftwood_slab", DRIFTWOOD_PLANKS);
    public static final RegistrySupplier<Block> DRIFTWOOD_STAIRS = ModBlocks.registerStairs("driftwood_stairs", DRIFTWOOD_PLANKS);
    public static final RegistrySupplier<Block> DRIFTWOOD_DOOR = ModBlocks.registerDecay("driftwood_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_284180_(MapColor.f_283818_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_(), BlockSetType.f_271198_));
    public static final RegistrySupplier<Block> DRIFTWOOD_TRAPDOOR = ModBlocks.registerDecay("driftwood_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_284180_(MapColor.f_283818_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_((state, world, pos, type) -> false), BlockSetType.f_271198_));
    public static final RegistrySupplier<Block> AMALGAM_BLOCK = ModBlocks.registerDecay("amalgam_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283779_).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistrySupplier<Block> AMALGAM_DOOR = ModBlocks.registerDecay("amalgam_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_284180_(MapColor.f_283779_).m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_(), BlockSetType.f_271132_));
    public static final RegistrySupplier<Block> AMALGAM_TRAPDOOR = ModBlocks.registerDecay("amalgam_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60922_((state, world, pos, type) -> false), BlockSetType.f_271132_));
    public static final RegistrySupplier<Block> RUST = ModBlocks.registerDecay("rust", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistrySupplier<Block> AMALGAM_SLAB = ModBlocks.registerSlab("amalgam_slab", AMALGAM_BLOCK);
    public static final RegistrySupplier<Block> AMALGAM_STAIRS = ModBlocks.registerStairs("amalgam_stairs", AMALGAM_BLOCK);
    public static final RegistrySupplier<Block> AMALGAM_ORE = ModBlocks.registerDecay("amalgam_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60999_().m_60913_(3.0f, 3.0f)));
    public static final RegistrySupplier<Block> CLOD_ORE = ModBlocks.registerDecay("clod_ore", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final RegistrySupplier<Block> CLOD_BLOCK = ModBlocks.registerDecay("clod_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final RegistrySupplier<Block> GRAVEL_FENCE = ModBlocks.registerFence("gravel_fence", Blocks.f_49994_);
    public static final RegistrySupplier<Block> GRAVEL_BUTTON = ModBlocks.registerButton("gravel_button", Blocks.f_49994_);
    public static final RegistrySupplier<Block> GRAVEL_SLAB = ModBlocks.registerSlab("gravel_slab", Blocks.f_49994_);
    public static final RegistrySupplier<Block> GRAVEL_STAIRS = ModBlocks.registerStairs("gravel_stairs", Blocks.f_49994_);
    public static final RegistrySupplier<Block> GRAVEL_WALL = ModBlocks.registerWall("gravel_wall", Blocks.f_49994_);
    public static final RegistrySupplier<Block> DARK_SAND = ModBlocks.register("dark_sand", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_).m_284180_(MapColor.f_283927_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
    public static final RegistrySupplier<Block> DARK_SAND_FENCE = ModBlocks.registerFence("dark_sand_fence", DARK_SAND);
    public static final RegistrySupplier<Block> DARK_SAND_BUTTON = ModBlocks.registerButton("dark_sand_button", DARK_SAND);
    public static final RegistrySupplier<Block> DARK_SAND_SLAB = ModBlocks.registerSlab("dark_sand_slab", DARK_SAND);
    public static final RegistrySupplier<Block> DARK_SAND_STAIRS = ModBlocks.registerStairs("dark_sand_stairs", DARK_SAND);
    public static final RegistrySupplier<Block> DARK_SAND_WALL = ModBlocks.registerWall("dark_sand_wall", DARK_SAND);
    public static final RegistrySupplier<Block> CLAY_FENCE = ModBlocks.registerFence("clay_fence", Blocks.f_50129_);
    public static final RegistrySupplier<Block> CLAY_GATE = ModBlocks.registerFenceGate("clay_gate", Blocks.f_50129_);
    public static final RegistrySupplier<Block> CLAY_BUTTON = ModBlocks.registerButton("clay_button", Blocks.f_50129_);
    public static final RegistrySupplier<Block> CLAY_SLAB = ModBlocks.registerSlab("clay_slab", Blocks.f_50129_);
    public static final RegistrySupplier<Block> CLAY_STAIRS = ModBlocks.registerStairs("clay_stairs", Blocks.f_50129_);
    public static final RegistrySupplier<Block> CLAY_WALL = ModBlocks.registerWall("clay_wall", Blocks.f_50129_);
    public static final RegistrySupplier<Block> MUD_FENCE = ModBlocks.registerFence("mud_fence", Blocks.f_220864_);
    public static final RegistrySupplier<Block> MUD_GATE = ModBlocks.registerFenceGate("mud_gate", Blocks.f_220864_);
    public static final RegistrySupplier<Block> MUD_BUTTON = ModBlocks.registerButton("mud_button", Blocks.f_220864_);
    public static final RegistrySupplier<Block> MUD_SLAB = ModBlocks.registerSlab("mud_slab", Blocks.f_220864_);
    public static final RegistrySupplier<Block> MUD_STAIRS = ModBlocks.registerStairs("mud_stairs", Blocks.f_220864_);
    public static final RegistrySupplier<Block> UNRAVELED_FENCE = ModBlocks.registerFence("unraveled_fence", UNRAVELLED_FABRIC);
    public static final RegistrySupplier<Block> UNRAVELED_GATE = ModBlocks.registerFenceGate("unraveled_gate", UNRAVELLED_FABRIC);
    public static final RegistrySupplier<Block> UNRAVELED_BUTTON = ModBlocks.registerButton("unraveled_button", UNRAVELLED_FABRIC);
    public static final RegistrySupplier<Block> UNRAVELED_SLAB = ModBlocks.registerSlab("unraveled_slab", UNRAVELLED_FABRIC);
    public static final RegistrySupplier<Block> UNRAVELED_STAIRS = ModBlocks.registerStairs("unraveled_stairs", UNRAVELLED_FABRIC);
    public static final RegistrySupplier<Block> DEEPSLATE_SLAB = ModBlocks.registerSlab("deepslate_slab", Blocks.f_152550_);
    public static final RegistrySupplier<Block> DEEPSLATE_STAIRS = ModBlocks.registerStairs("deepslate_stairs", Blocks.f_152550_);
    public static final RegistrySupplier<Block> DEEPSLATE_WALL = ModBlocks.registerWall("deepslate_wall", Blocks.f_152550_);
    public static final RegistrySupplier<Block> RED_SAND_SLAB = ModBlocks.registerSlab("red_sand_slab", Blocks.f_49993_);
    public static final RegistrySupplier<Block> RED_SAND_STAIRS = ModBlocks.registerStairs("red_sand_stairs", Blocks.f_49993_);
    public static final RegistrySupplier<Block> RED_SAND_WALL = ModBlocks.registerWall("red_sand_wall", Blocks.f_49993_);
    public static final RegistrySupplier<Block> SAND_SLAB = ModBlocks.registerSlab("sand_slab", Blocks.f_49992_);
    public static final RegistrySupplier<Block> SAND_STAIRS = ModBlocks.registerStairs("sand_stairs", Blocks.f_49992_);
    public static final RegistrySupplier<Block> SAND_WALL = ModBlocks.registerWall("sand_wall", Blocks.f_49992_);
    public static final RegistrySupplier<Block> END_STONE_SLAB = ModBlocks.registerSlab("end_stone_slab", Blocks.f_50259_);
    public static final RegistrySupplier<Block> END_STONE_STAIRS = ModBlocks.registerStairs("end_stone_stairs", Blocks.f_50259_);
    public static final RegistrySupplier<Block> END_STONE_WALL = ModBlocks.registerWall("end_stone_wall", Blocks.f_50259_);
    public static final RegistrySupplier<Block> NETHERRACK_FENCE = ModBlocks.registerFence("netherrack_fence", Blocks.f_50134_);
    public static final RegistrySupplier<Block> NETHERRACK_SLAB = ModBlocks.registerSlab("netherrack_slab", Blocks.f_50134_);
    public static final RegistrySupplier<Block> NETHERRACK_STAIRS = ModBlocks.registerStairs("netherrack_stairs", Blocks.f_50134_);
    public static final RegistrySupplier<Block> NETHERRACK_WALL = ModBlocks.registerWall("netherrack_wall", Blocks.f_50134_);
    public static final RegistrySupplier<Block> UNRAVELED_SPIKE = ModBlocks.registerDecay("unraveled_spike", () -> new PointedDripstoneBlock(ModBlocks.of((Block)UNRAVELLED_FABRIC.get()).m_60953_(state -> 0)));
    public static final RegistrySupplier<Block> GRITTY_STONE = ModBlocks.registerDecay("gritty_stone", () -> new Block(ModBlocks.of(Blocks.f_50069_)));

    public static void init() {
        BLOCKS.register();
        BLOCK_ITEMS.register();
    }

    private static <T extends Block> RegistrySupplier<T> registerWithoutTabOrItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static RegistrySupplier<Block> registerAncientFabric(DyeColor color) {
        RegistrySupplier<Block> block = ModBlocks.register(color.m_7912_() + "_ancient_fabric", () -> new AncientFabricBlock(color));
        ANCIENT_FABRIC_BLOCKS.put(color, block);
        return block;
    }

    private static RegistrySupplier<Block> registerFabric(DyeColor color) {
        RegistrySupplier<Block> block = ModBlocks.register(color.m_7912_() + "_fabric", () -> new FabricBlock(color));
        FABRIC_BLOCKS.put(color, block);
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)QUARTZ_DOOR.get(), (Block)GOLD_DOOR.get(), (Block)DRIFTWOOD_LEAVES.get(), (Block)UNRAVELED_SPIKE.get(), (Block)DRIFTWOOD_DOOR.get()});
    }

    public static RegistrySupplier<Block> ancientFabricFromDye(DyeColor color) {
        return ANCIENT_FABRIC_BLOCKS.get(color);
    }

    public static RegistrySupplier<Block> fabricFromDye(DyeColor color) {
        return FABRIC_BLOCKS.get(color);
    }

    public static <T extends Block> RegistrySupplier<T> register(String name, Supplier<T> block) {
        RegistrySupplier supplier = BLOCKS.register(name, block);
        BLOCK_ITEMS.register(name, () -> new BlockItem((Block)supplier.get(), new Item.Properties().arch$tab(ModItems.DIMENSIONAL_DOORS)));
        return supplier;
    }

    public static <T extends Block> RegistrySupplier<T> registerDecay(String name, Supplier<T> block) {
        RegistrySupplier supplier = BLOCKS.register(name, block);
        BLOCK_ITEMS.register(name, () -> new BlockItem((Block)supplier.get(), new Item.Properties().arch$tab(ModItems.DECAY)));
        return supplier;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutTab(String name, Supplier<T> block) {
        RegistrySupplier supplier = BLOCKS.register(name, block);
        BLOCK_ITEMS.register(name, () -> new BlockItem((Block)supplier.get(), new Item.Properties()));
        return supplier;
    }

    public static RegistrySupplier<Block> registerFence(String name, Block block) {
        return ModBlocks.registerDecay(name, () -> new FenceBlock(ModBlocks.of(block)));
    }

    public static RegistrySupplier<Block> registerFence(String name, RegistrySupplier<Block> block) {
        return ModBlocks.registerDecay(name, () -> new FenceBlock(ModBlocks.of((Block)block.get())));
    }

    public static RegistrySupplier<Block> registerFenceGate(String name, Block block) {
        return ModBlocks.registerDecay(name, () -> new FenceGateBlock(ModBlocks.of(block), WoodType.f_61830_));
    }

    public static RegistrySupplier<Block> registerFenceGate(String name, RegistrySupplier<Block> block) {
        return ModBlocks.registerDecay(name, () -> new FenceGateBlock(ModBlocks.of((Block)block.get()), WoodType.f_61830_));
    }

    public static RegistrySupplier<Block> registerButton(String name, Block block) {
        return ModBlocks.registerDecay(name, () -> new ButtonBlock(ModBlocks.of(block).m_60910_().m_60978_(0.5f), BlockSetType.f_271479_, 20, false));
    }

    public static RegistrySupplier<Block> registerButton(String name, RegistrySupplier<Block> block) {
        return ModBlocks.registerDecay(name, () -> new ButtonBlock(ModBlocks.of((Block)block.get()).m_60910_().m_60978_(0.5f), BlockSetType.f_271479_, 20, false));
    }

    public static RegistrySupplier<Block> registerSlab(String name, Block block) {
        return ModBlocks.registerDecay(name, () -> new SlabBlock(ModBlocks.of(block)));
    }

    public static RegistrySupplier<Block> registerSlab(String name, RegistrySupplier<Block> block) {
        return ModBlocks.registerDecay(name, () -> new SlabBlock(ModBlocks.of((Block)block.get())));
    }

    public static RegistrySupplier<Block> registerStairs(String name, Block block) {
        return ModBlocks.registerDecay(name, () -> new StairBlock(block.m_49966_(), ModBlocks.of(block)));
    }

    public static RegistrySupplier<Block> registerStairs(String name, RegistrySupplier<Block> block) {
        return ModBlocks.registerDecay(name, () -> {
            Block b = (Block)block.get();
            return new StairBlock(b.m_49966_(), ModBlocks.of(b));
        });
    }

    public static RegistrySupplier<Block> registerWall(String name, Block block) {
        return ModBlocks.registerDecay(name, () -> new WallBlock(ModBlocks.of(block)));
    }

    public static RegistrySupplier<Block> registerWall(String name, RegistrySupplier<Block> block) {
        return ModBlocks.registerDecay(name, () -> new WallBlock(ModBlocks.of((Block)block.get())));
    }

    private static BlockBehaviour.Properties of(Block block) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)block);
    }
}

