/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import java.util.ArrayList;
import java.util.List;
import org.dimdev.dimdoors.api.util.math.AbstractMatrixd;
import org.dimdev.dimdoors.api.util.math.TransformationMatrixd;
import org.dimdev.dimdoors.api.util.math.Vectord;

public abstract class TransformationMatrixdImpl<T extends AbstractMatrixd<T>>
extends AbstractMatrixd<T> {
    public TransformationMatrixdImpl(double[][] matrix) {
        super(matrix);
        if (this.getDimensionX() != this.getDimensionY()) {
            throw new UnsupportedOperationException("Cannot create TransformationMatrixd from non square 2D array.");
        }
    }

    public TransformationMatrixdImpl(AbstractMatrixd<?> matrix) {
        super(matrix);
        if (this.getDimensionX() != this.getDimensionY()) {
            throw new UnsupportedOperationException("Cannot create TransformationMatrixd from non square matrix.");
        }
    }

    public TransformationMatrixdImpl(Vectord ... vectors) {
        super(vectors);
        if (this.getDimensionX() != this.getDimensionY()) {
            throw new UnsupportedOperationException("Cannot create TransformationMatrixd from non square vector array.");
        }
    }

    public int getBase() {
        return this.getDimensionX() - 1;
    }

    public Vectord transform(Vectord vector) {
        if (vector.size() != this.getBase()) {
            throw new UnsupportedOperationException("Cannot transform vector of non matching base");
        }
        return this.product(vector.append(1.0)).drop(vector.size());
    }

    public static abstract class TransformationMatrixdBuilderImpl<V extends TransformationMatrixdBuilderImpl<V, U>, U extends TransformationMatrixdImpl<U>> {
        private final int base;
        private final U instance;
        private final List<TransformationMatrixdImpl<?>> transformers = new ArrayList();
        private final List<TransformationMatrixdImpl<?>> reverseTransformers = new ArrayList();

        protected TransformationMatrixdBuilderImpl(int base, U instance) {
            this.base = base;
            this.instance = instance;
        }

        public abstract V getSelf();

        public U build() {
            TransformationMatrixd transformer = TransformationMatrixd.identity(this.base);
            for (TransformationMatrixdImpl<?> transformationMatrix : this.transformers) {
                transformer = (TransformationMatrixd)transformer.product(transformationMatrix);
            }
            return (U)((TransformationMatrixdImpl)((AbstractMatrixd)this.instance).construct(transformer));
        }

        public U buildReverse() {
            TransformationMatrixd transformer = TransformationMatrixd.identity(this.base);
            for (TransformationMatrixdImpl<?> transformationMatrix : this.reverseTransformers) {
                transformer = (TransformationMatrixd)transformer.product(transformationMatrix);
            }
            return (U)((TransformationMatrixdImpl)((AbstractMatrixd)this.instance).construct(transformer));
        }

        public V translate(Vectord translation) {
            TransformationMatrixdImpl transformer = (TransformationMatrixdImpl)TransformationMatrixd.identity(this.base).setColumn(this.base, translation.append(1.0));
            this.transformers.add(0, transformer);
            TransformationMatrixdImpl reverseTransformer = (TransformationMatrixdImpl)TransformationMatrixd.identity(this.base).setColumn(this.base, translation.invert().append(1.0));
            this.reverseTransformers.add(reverseTransformer);
            return this.getSelf();
        }

        public V rotateAroundBasePlane(double angle, int planeBaseVectorIndex1, int planeBaseVectorIndex2) {
            Vectord column1 = new Vectord(this.base + 1).set(planeBaseVectorIndex1, Math.cos(angle)).set(planeBaseVectorIndex2, Math.sin(angle));
            Vectord column2 = new Vectord(this.base + 1).set(planeBaseVectorIndex1, -Math.sin(angle)).set(planeBaseVectorIndex2, Math.cos(angle));
            TransformationMatrixdImpl transformer = (TransformationMatrixdImpl)((TransformationMatrixd)TransformationMatrixd.identity(this.base).setColumn(planeBaseVectorIndex1, column1)).setColumn(planeBaseVectorIndex2, column2);
            this.transformers.add(0, transformer);
            column1 = new Vectord(this.base + 1).set(planeBaseVectorIndex1, Math.cos(angle)).set(planeBaseVectorIndex2, -Math.sin(angle));
            column2 = new Vectord(this.base + 1).set(planeBaseVectorIndex1, Math.sin(angle)).set(planeBaseVectorIndex2, Math.cos(angle));
            TransformationMatrixdImpl reverseTransformer = (TransformationMatrixdImpl)((TransformationMatrixd)TransformationMatrixd.identity(this.base).setColumn(planeBaseVectorIndex1, column1)).setColumn(planeBaseVectorIndex2, column2);
            this.reverseTransformers.add(reverseTransformer);
            return this.getSelf();
        }
    }
}

