/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.Guis;
import wile.engineersdecor.libmc.Inventories;
import wile.engineersdecor.libmc.Networking;
import wile.engineersdecor.libmc.RsSignals;
import wile.engineersdecor.libmc.StandardBlocks;
import wile.engineersdecor.libmc.StandardEntityBlocks;
import wile.engineersdecor.libmc.TooltipDisplay;

public class EdHopper {
    public static void on_config() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HopperGui
    extends Guis.ContainerGui<HopperContainer> {
        public HopperGui(HopperContainer container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/factory_hopper_gui.png");
        }

        @Override
        public void m_7856_() {
            super.m_7856_();
            Block block = ModContent.getBlock(Auxiliaries.getResourceLocation(((HopperContainer)this.m_6262_()).m_6772_()).m_135815_().replaceAll("^ct_", ""));
            String prefix = block.m_7705_() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 148, y0 + 22, 3, 3, (Component)Component.m_237115_((String)(prefix + "delayindicator"))), new TooltipDisplay.TipRange(x0 + 130, y0 + 9, 40, 10, (Component)Component.m_237115_((String)(prefix + "range"))), new TooltipDisplay.TipRange(x0 + 130, y0 + 22, 40, 10, (Component)Component.m_237115_((String)(prefix + "period"))), new TooltipDisplay.TipRange(x0 + 130, y0 + 35, 40, 10, (Component)Component.m_237115_((String)(prefix + "count"))), new TooltipDisplay.TipRange(x0 + 133, y0 + 49, 9, 9, (Component)Component.m_237115_((String)(prefix + "rssignal"))), new TooltipDisplay.TipRange(x0 + 145, y0 + 49, 9, 9, (Component)Component.m_237115_((String)(prefix + "inversion"))), new TooltipDisplay.TipRange(x0 + 159, y0 + 49, 9, 9, (Component)Component.m_237115_((String)(prefix + "triggermode"))));
        }

        @Override
        protected void renderBgWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            ResourceLocation bg = this.background_image_;
            HopperContainer container = (HopperContainer)this.m_6262_();
            int slot_index = container.field(6);
            if (slot_index < 0 || slot_index >= 18) {
                slot_index = 0;
            }
            int x = x0 + 10 + slot_index % 6 * 18;
            int y = y0 + 8 + slot_index / 6 * 17;
            graphics.m_280218_(bg, x, y, 200, 8, 18, 18);
            int[] lut = new int[]{133, 141, 149, 157, 166};
            int px = lut[Mth.m_14045_((int)container.field(0), (int)0, (int)4)];
            int x2 = x0 + px - 2;
            int y2 = y0 + 14;
            graphics.m_280218_(bg, x2, y2, 179, 40, 5, 5);
            int px2 = (int)Math.round(33.5 * (double)container.field(3) / 100.0 + 1.0);
            x = x0 + 132 - 2 + Mth.m_14045_((int)px2, (int)0, (int)34);
            y = y0 + 27;
            graphics.m_280218_(bg, x, y, 179, 40, 5, 5);
            int x3 = x0 + 133 - 2 + container.field(1);
            int y3 = y0 + 40;
            graphics.m_280218_(bg, x3, y3, 179, 40, 5, 5);
            if (container.field(5) != 0) {
                graphics.m_280218_(bg, x0 + 133, y0 + 49, 217, 49, 9, 9);
            }
            int inverter_offset_x = (container.field(2) & 1) != 0 ? 11 : 0;
            int inverter_offset_y = (container.field(2) & 4) != 0 ? 10 : 0;
            graphics.m_280218_(bg, x0 + 145, y0 + 49, 177 + inverter_offset_x, 49 + inverter_offset_y, 9, 9);
            int pulse_mode_offset = (container.field(2) & 2) != 0 ? 9 : 0;
            graphics.m_280218_(bg, x0 + 159, y0 + 49, 199 + pulse_mode_offset, 49, 9, 9);
            if (container.field(4) > 10 && System.currentTimeMillis() % 1000L < 500L) {
                graphics.m_280218_(bg, x0 + 148, y0 + 22, 187, 22, 3, 3);
            }
        }

        protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
            this.tooltip_.resetTimer();
            if (type == ClickType.QUICK_MOVE && slot != null && slot.m_6657_() && Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", slotId);
                ((HopperContainer)this.f_97732_).onGuiAction("quick-move-all", nbt);
            } else {
                super.m_6597_(slot, slotId, button, type);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            HopperContainer container = (HopperContainer)this.m_6262_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.m_6774_(126, 1, 49, 60, mouseX, mouseY)) {
                return super.m_6375_(mouseX, mouseY, mouseButton);
            }
            if (this.m_6774_(128, 9, 44, 10, mouseX, mouseY)) {
                int range = mx - 133;
                if (range < -1) {
                    range = container.field(0) - 1;
                } else if (range >= 34) {
                    range = container.field(0) + 1;
                } else {
                    range = (int)(0.5 + 4.0 * (double)range / 34.0);
                    range = Mth.m_14045_((int)range, (int)0, (int)4);
                }
                container.onGuiAction("range", range);
            } else if (this.m_6774_(128, 21, 44, 10, mouseX, mouseY)) {
                int period = mx - 133;
                period = period < -1 ? container.field(3) - 3 : (period >= 35 ? container.field(3) + 3 : (int)(0.5 + 100.0 * (double)period / 34.0));
                period = Mth.m_14045_((int)period, (int)0, (int)100);
                container.onGuiAction("period", period);
            } else if (this.m_6774_(128, 34, 44, 10, mouseX, mouseY)) {
                int ndrop = mx - 134;
                ndrop = ndrop < -1 ? container.field(1) - 1 : (ndrop >= 34 ? container.field(1) + 1 : Mth.m_14045_((int)(1 + ndrop), (int)1, (int)32));
                container.onGuiAction("xsize", ndrop);
            } else if (this.m_6774_(133, 49, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("manual_trigger", 1);
            } else if (this.m_6774_(145, 49, 9, 9, mouseX, mouseY)) {
                int mask = 5;
                int logic = switch (container.field(2) & 5) {
                    case 0 -> 1;
                    case 1 -> 4;
                    case 4 -> 0;
                    default -> 4;
                };
                container.onGuiAction("logic", container.field(2) & 0xFFFFFFFA | logic);
            } else if (this.m_6774_(159, 49, 7, 9, mouseX, mouseY)) {
                container.onGuiAction("logic", container.field(2) ^ 2);
            }
            return true;
        }
    }

    public static class HopperContainer
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        protected static final String QUICK_MOVE_ALL = "quick-move-all";
        private static final int PLAYER_INV_START_SLOTNO = 18;
        private static final int NUM_OF_CONTAINER_SLOTS = 54;
        protected static final int STORAGE_SLOT_BEGIN = 0;
        protected static final int STORAGE_SLOT_END = 18;
        protected static final int PLAYER_SLOT_BEGIN = 18;
        protected static final int PLAYER_SLOT_END = 54;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange block_storage_range_;
        private final Player player_;
        private final Container inventory_;
        private final ContainerLevelAccess wpc_;
        private final ContainerData fields_;

        public final int field(int index) {
            return this.fields_.m_6413_(index);
        }

        public HopperContainer(int cid, Inventory player_inventory) {
            this(cid, player_inventory, (Container)new SimpleContainer(18), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(7));
        }

        private HopperContainer(int cid, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(ModContent.getMenuType("factory_hopper"), cid);
            int x;
            int y;
            this.fields_ = fields;
            this.wpc_ = wpc;
            this.player_ = player_inventory.f_35978_;
            this.inventory_ = block_inventory;
            this.block_storage_range_ = new Inventories.InventoryRange(this.inventory_, 0, 18);
            this.player_inventory_range_ = Inventories.InventoryRange.fromPlayerInventory(this.player_);
            int i = -1;
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 11 + x * 18;
                    int ypos = 9 + y * 17;
                    this.m_38897_(new Slot(this.inventory_, ++i, xpos, ypos));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)player_inventory, x2, 8 + x2 * 18, 129));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y * 9 + 9, 8 + x * 18, 71 + y * 18));
                }
            }
            this.m_38884_(this.fields_);
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = this.m_38853_(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index >= 0 && index < 18) {
                if (!this.m_38903_(slot_stack, 18, 54, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 18 && index <= 54) {
                if (!this.m_38903_(slot_stack, 0, 18, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundTag nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundTag nbt) {
            nbt.m_128359_("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
            if (!(this.inventory_ instanceof Inventories.StorageInventory)) {
                return;
            }
            BlockEntity blockEntity = ((Inventories.StorageInventory)this.inventory_).getBlockEntity();
            if (!(blockEntity instanceof HopperTileEntity)) {
                return;
            }
            HopperTileEntity te = (HopperTileEntity)blockEntity;
            if (nbt.m_128441_("xsize")) {
                te.transfer_count_ = Mth.m_14045_((int)nbt.m_128451_("xsize"), (int)1, (int)32);
            }
            if (nbt.m_128441_("period")) {
                te.transfer_period_ = Mth.m_14045_((int)nbt.m_128451_("period"), (int)0, (int)100);
            }
            if (nbt.m_128441_("range")) {
                te.collection_range_ = Mth.m_14045_((int)nbt.m_128451_("range"), (int)0, (int)4);
            }
            if (nbt.m_128441_("logic")) {
                te.logic_ = nbt.m_128451_("logic");
            }
            if (nbt.m_128441_("manual_trigger") && nbt.m_128451_("manual_trigger") != 0) {
                te.block_power_signal_ = true;
                te.block_power_updated_ = true;
                te.tick_timer_ = 1;
            }
            if (nbt.m_128441_("action")) {
                boolean changed = false;
                int slotId = nbt.m_128441_("slot") ? nbt.m_128451_("slot") : -1;
                switch (nbt.m_128461_("action")) {
                    case "quick-move-all": {
                        if (slotId >= 0 && slotId < 18 && this.m_38853_(slotId).m_6657_()) {
                            changed = this.block_storage_range_.move(this.m_38853_(slotId).getSlotIndex(), this.player_inventory_range_, true, false, true, true);
                            break;
                        }
                        if (slotId < 18 || slotId >= 54 || !this.m_38853_(slotId).m_6657_()) break;
                        changed = this.player_inventory_range_.move(this.m_38853_(slotId).getSlotIndex(), this.block_storage_range_, true, false, false, true);
                    }
                }
                if (changed) {
                    this.inventory_.m_6596_();
                    player.m_150109_().m_6596_();
                    this.m_38946_();
                }
            }
            te.m_6596_();
        }
    }

    public static class HopperTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable {
        public static final int NUM_OF_FIELDS = 7;
        public static final int TICK_INTERVAL = 10;
        public static final int COLLECTION_INTERVAL = 50;
        public static final int NUM_OF_SLOTS = 18;
        public static final int NUM_OF_STORAGE_SLOTS = 18;
        public static final int MAX_TRANSFER_COUNT = 32;
        public static final int MAX_COLLECTION_RANGE = 4;
        public static final int PERIOD_OFFSET = 10;
        public static final int LOGIC_NOT_INVERTED = 0;
        public static final int LOGIC_INVERTED = 1;
        public static final int LOGIC_CONTINUOUS = 2;
        public static final int LOGIC_IGNORE_EXT = 4;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int collection_timer_ = 0;
        private int delay_timer_ = 0;
        private int transfer_count_ = 1;
        private int logic_ = 3;
        private int transfer_period_ = 0;
        private int collection_range_ = 0;
        private int current_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected final Inventories.StorageInventory main_inventory_ = new Inventories.StorageInventory(this, 18, 1);
        protected final Inventories.InventoryRange storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 0, 18);
        protected LazyOptional<? extends IItemHandler> item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.storage_slot_range_);
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 7;
            }

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> collection_range_;
                    case 1 -> transfer_count_;
                    case 2 -> logic_;
                    case 3 -> transfer_period_;
                    case 4 -> delay_timer_;
                    case 5 -> {
                        if (block_power_signal_) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 6 -> current_slot_index_;
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        collection_range_ = Mth.m_14045_((int)value, (int)0, (int)4);
                        break;
                    }
                    case 1: {
                        transfer_count_ = Mth.m_14045_((int)value, (int)1, (int)32);
                        break;
                    }
                    case 2: {
                        logic_ = value;
                        break;
                    }
                    case 3: {
                        transfer_period_ = Mth.m_14045_((int)value, (int)0, (int)100);
                        break;
                    }
                    case 4: {
                        delay_timer_ = Mth.m_14045_((int)value, (int)0, (int)400);
                        break;
                    }
                    case 5: {
                        block_power_signal_ = value != 0;
                        break;
                    }
                    case 6: {
                        current_slot_index_ = Mth.m_14045_((int)value, (int)0, (int)17);
                    }
                }
            }
        };

        public HopperTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
            this.main_inventory_.setSlotChangeAction((slot, stack) -> {
                this.tick_timer_ = Math.min(this.tick_timer_, 8);
            });
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
        }

        public CompoundTag clear_getnbt() {
            CompoundTag nbt = new CompoundTag();
            this.block_power_signal_ = false;
            this.writenbt(nbt, false);
            boolean is_empty = this.main_inventory_.m_7983_();
            this.main_inventory_.m_6211_();
            this.reset_rtstate();
            this.block_power_updated_ = false;
            if (is_empty) {
                nbt = new CompoundTag();
            }
            return nbt;
        }

        public void readnbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.load(nbt);
            this.block_power_signal_ = nbt.m_128471_("powered");
            this.current_slot_index_ = nbt.m_128451_("act_slot_index");
            this.transfer_count_ = Mth.m_14045_((int)nbt.m_128451_("xsize"), (int)1, (int)32);
            this.logic_ = nbt.m_128451_("logic");
            this.transfer_period_ = nbt.m_128451_("period");
            this.collection_range_ = nbt.m_128451_("range");
        }

        protected void writenbt(CompoundTag nbt, boolean update_packet) {
            this.main_inventory_.save(nbt);
            nbt.m_128379_("powered", this.block_power_signal_);
            nbt.m_128405_("act_slot_index", this.current_slot_index_);
            nbt.m_128405_("xsize", this.transfer_count_);
            nbt.m_128405_("logic", this.logic_);
            nbt.m_128405_("period", this.transfer_period_);
            nbt.m_128405_("range", this.collection_range_);
        }

        public void block_updated() {
            boolean powered = this.f_58857_.m_276867_(this.f_58858_);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            this.tick_timer_ = 1;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt, false);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt, false);
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_handler_.invalidate();
        }

        public Component m_7755_() {
            return Auxiliaries.localizable(this.m_58900_().m_60734_().m_7705_());
        }

        public boolean m_8077_() {
            return false;
        }

        public Component m_7770_() {
            return this.m_7755_();
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new HopperContainer(id, inventory, this.main_inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private IItemHandler inventory_entity_handler(BlockPos where) {
            List entities = this.f_58857_.m_6249_((Entity)null, new AABB(where), EntitySelector.f_20405_);
            return entities.isEmpty() ? null : Inventories.itemhandler((Entity)entities.get(0));
        }

        private static int next_slot(int i) {
            return i < 17 ? i + 1 : 0;
        }

        private int try_insert_into_hopper(ItemStack stack) {
            int max_to_insert;
            int n_to_insert = max_to_insert = stack.m_41613_();
            int first_empty_slot = -1;
            for (int i = 0; i < this.storage_slot_range_.size(); ++i) {
                int nspace;
                ItemStack slotstack = this.storage_slot_range_.get(i);
                if (first_empty_slot < 0 && slotstack.m_41619_()) {
                    first_empty_slot = i;
                    continue;
                }
                if (Inventories.areItemStacksDifferent(stack, slotstack) || (nspace = slotstack.m_41741_() - slotstack.m_41613_()) <= 0) continue;
                if (nspace >= n_to_insert) {
                    slotstack.m_41769_(n_to_insert);
                    n_to_insert = 0;
                    break;
                }
                slotstack.m_41769_(nspace);
                n_to_insert -= nspace;
            }
            if (n_to_insert > 0 && first_empty_slot >= 0) {
                ItemStack new_stack = stack.m_41777_();
                new_stack.m_41764_(n_to_insert);
                this.storage_slot_range_.set(first_empty_slot, new_stack);
                n_to_insert = 0;
            }
            return max_to_insert - n_to_insert;
        }

        private boolean try_insert(Direction facing) {
            int num_inserted;
            ItemStack target_stack;
            int i;
            ItemStack current_stack = ItemStack.f_41583_;
            for (int i2 = 0; i2 < 18; ++i2) {
                if (this.current_slot_index_ >= 18) {
                    this.current_slot_index_ = 0;
                }
                if (!(current_stack = this.storage_slot_range_.get(this.current_slot_index_)).m_41619_()) break;
                this.current_slot_index_ = HopperTileEntity.next_slot(this.current_slot_index_);
            }
            if (current_stack.m_41619_()) {
                this.current_slot_index_ = 0;
                return false;
            }
            BlockPos facing_pos = this.f_58858_.m_121945_(facing);
            IItemHandler ih = null;
            BlockEntity te = this.f_58857_.m_7702_(facing_pos);
            if (te != null) {
                Direction f;
                ih = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null);
                if (ih == null) {
                    this.delay_timer_ = 12;
                    return false;
                }
                if (te instanceof HopperBlockEntity ? (f = (Direction)this.f_58857_.m_8055_(facing_pos).m_61143_((Property)net.minecraft.world.level.block.HopperBlock.f_54021_)) == facing.m_122424_() : te instanceof HopperTileEntity && (f = (Direction)this.f_58857_.m_8055_(facing_pos).m_61143_((Property)HopperBlock.FACING)) == facing.m_122424_()) {
                    return false;
                }
            }
            if (ih == null) {
                ih = this.inventory_entity_handler(facing_pos);
            }
            if (ih == null) {
                this.delay_timer_ = 12;
                return false;
            }
            ItemStack insert_stack = current_stack.m_41777_();
            if (insert_stack.m_41613_() > this.transfer_count_) {
                insert_stack.m_41764_(this.transfer_count_);
            }
            int initial_insert_stack_size = insert_stack.m_41613_();
            if (ih == null || ih.getSlots() <= 0) {
                return false;
            }
            for (i = 0; i < ih.getSlots() && (Inventories.areItemStacksDifferent(target_stack = ih.getStackInSlot(i), insert_stack) || !(insert_stack = ih.insertItem(i, insert_stack.m_41777_(), false)).m_41619_()); ++i) {
            }
            if (!insert_stack.m_41619_()) {
                for (i = 0; i < ih.getSlots() && !(insert_stack = ih.insertItem(i, insert_stack.m_41777_(), false)).m_41619_(); ++i) {
                }
            }
            if ((num_inserted = initial_insert_stack_size - insert_stack.m_41613_()) > 0) {
                current_stack.m_41774_(num_inserted);
                this.storage_slot_range_.set(this.current_slot_index_, current_stack);
            }
            if (!insert_stack.m_41619_()) {
                this.current_slot_index_ = HopperTileEntity.next_slot(this.current_slot_index_);
            }
            return num_inserted > 0;
        }

        private boolean try_item_handler_extract(IItemHandler ih) {
            int end = ih.getSlots();
            int n_to_extract = this.transfer_count_;
            for (int i = 0; i < end; ++i) {
                int n_accepted;
                ItemStack stack;
                if (ih.getStackInSlot(i).m_41619_() || (stack = ih.extractItem(i, n_to_extract, true)).m_41619_() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                ItemStack test = ih.extractItem(i, n_accepted, false);
                if ((n_to_extract -= n_accepted) <= 0) break;
            }
            return n_to_extract < this.transfer_count_;
        }

        private boolean try_inventory_extract(Container inv) {
            int end = inv.m_6643_();
            int n_to_extract = this.transfer_count_;
            for (int i = 0; i < end; ++i) {
                int n_accepted;
                ItemStack stack = inv.m_8020_(i).m_41777_();
                if (stack.m_41619_() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                stack.m_41774_(n_accepted);
                n_to_extract -= n_accepted;
                if (stack.m_41619_()) {
                    stack = ItemStack.f_41583_;
                }
                inv.m_6836_(i, stack);
                if (n_to_extract <= 0) break;
            }
            if (n_to_extract < this.transfer_count_) {
                inv.m_6596_();
                return true;
            }
            return false;
        }

        private boolean try_collect(Direction facing) {
            AABB collection_volume;
            Vec3 rpos;
            if (facing == Direction.UP) {
                rpos = new Vec3(0.5 + (double)this.f_58858_.m_123341_(), 1.5 + (double)this.f_58858_.m_123342_(), 0.5 + (double)this.f_58858_.m_123343_());
                collection_volume = new AABB(this.f_58858_.m_7494_()).m_82377_(0.1 + (double)this.collection_range_, 0.6, 0.1 + (double)this.collection_range_);
            } else {
                rpos = new Vec3(0.5 + (double)this.f_58858_.m_123341_(), -1.5 + (double)this.f_58858_.m_123342_(), 0.5 + (double)this.f_58858_.m_123343_());
                collection_volume = new AABB(this.f_58858_.m_6625_(2)).m_82377_(0.1 + (double)this.collection_range_, 1.0, 0.1 + (double)this.collection_range_);
            }
            List items = this.f_58857_.m_6443_(ItemEntity.class, collection_volume, e -> e.m_6084_() && e.m_20096_());
            if (items.size() <= 0) {
                return false;
            }
            int max_to_collect = 3;
            int n_collected = 0;
            for (ItemEntity ie : items) {
                int n_accepted;
                ItemStack stack;
                boolean is_direct_collection_tange;
                boolean bl = is_direct_collection_tange = ie.m_20238_(rpos) < 0.7;
                if (!is_direct_collection_tange && ie.m_32063_() || (stack = ie.m_32055_()).m_41619_() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                if (n_accepted >= stack.m_41613_()) {
                    stack.m_41764_(0);
                    ie.m_32045_(stack);
                    ie.m_142687_(Entity.RemovalReason.DISCARDED);
                } else {
                    stack.m_41774_(n_accepted);
                    ie.m_32045_(stack);
                }
                if (is_direct_collection_tange || ++n_collected < 3) continue;
                break;
            }
            return n_collected > 0;
        }

        @Override
        public void tick() {
            if (this.f_58857_.f_46443_) {
                return;
            }
            if (this.delay_timer_ > 0 && --this.delay_timer_ == 0) {
                this.m_6596_();
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 10;
            boolean dirty = this.block_power_updated_;
            boolean rssignal = (this.logic_ & 4) != 0 || (this.logic_ & 1) != 0 == !this.block_power_signal_;
            boolean pulse_mode = (this.logic_ & 6) == 0;
            boolean trigger = (this.logic_ & 4) != 0 || rssignal && (this.block_power_updated_ || !pulse_mode);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof HopperBlock)) {
                this.block_power_signal_ = false;
                return;
            }
            Direction hopper_facing = (Direction)state.m_61143_((Property)HopperBlock.FACING);
            boolean tr = this.f_58857_.m_276867_(this.f_58858_);
            this.block_power_updated_ = this.block_power_signal_ != tr;
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if (rssignal || pulse_mode) {
                IItemHandler ih;
                Direction hopper_input_facing = hopper_facing == Direction.UP ? Direction.DOWN : Direction.UP;
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(hopper_input_facing));
                IItemHandler iItemHandler = ih = te == null ? null : (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, hopper_input_facing.m_122424_()).orElse(null);
                if (ih != null || te instanceof WorldlyContainer) {
                    if (ih != null) {
                        if (this.try_item_handler_extract(ih)) {
                            dirty = true;
                        }
                    } else if (this.try_inventory_extract((Container)((WorldlyContainer)te))) {
                        dirty = true;
                    }
                }
                if (ih == null && (ih = this.inventory_entity_handler(this.f_58858_.m_121945_(hopper_input_facing))) != null && this.try_item_handler_extract(ih)) {
                    dirty = true;
                }
                if (ih == null && (this.collection_timer_ -= 10) <= 0) {
                    this.collection_timer_ = 50;
                    if (this.try_collect(hopper_input_facing)) {
                        dirty = true;
                    }
                }
            }
            if (trigger && this.delay_timer_ <= 0) {
                this.delay_timer_ = 10 + this.transfer_period_ * 2;
                if (this.try_insert(hopper_facing)) {
                    dirty = true;
                }
            }
            if (dirty) {
                this.m_6596_();
            }
            if (trigger && this.tick_timer_ > 10) {
                this.tick_timer_ = 10;
            }
        }
    }

    public static class HopperBlock
    extends StandardBlocks.Directed
    implements StandardEntityBlocks.IStandardEntityBlock<HopperTileEntity> {
        public HopperBlock(long config, BlockBehaviour.Properties builder, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config, builder, shape_supplier);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return Shapes.m_83144_();
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            int n;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof HopperTileEntity) {
                HopperTileEntity te = (HopperTileEntity)blockEntity;
                n = RsSignals.fromContainer(te.storage_slot_range_);
            } else {
                n = 0;
            }
            return n;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41783_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof HopperTileEntity)) {
                return;
            }
            ((HopperTileEntity)te).readnbt(te_nbt, false);
            ((HopperTileEntity)te).reset_rtstate();
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof HopperTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag te_nbt = ((HopperTileEntity)te).clear_getnbt();
                if (!te_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("tedata", (Tag)te_nbt);
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((HopperTileEntity)te).main_inventory_) {
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
                ((HopperTileEntity)te).reset_rtstate();
            }
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof Level) || world.f_46443_) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof HopperTileEntity)) {
                return;
            }
            ((HopperTileEntity)te).block_updated();
        }

        public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
            super.m_142072_(world, state, pos, entity, fallDistance);
            if (!(entity instanceof ItemEntity)) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof HopperTileEntity)) {
                return;
            }
            HopperTileEntity te = (HopperTileEntity)blockEntity;
            te.collection_timer_ = 0;
        }

        public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
            return false;
        }

        public boolean m_7899_(BlockState state) {
            return true;
        }

        public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }
    }
}

