/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.base.cables;

import com.drmangotea.tfmg.blocks.electricity.base.cables.WireManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class WireConnection {
    public final WireManager.Conductor material;
    public final float lenght;
    public final float resistance;
    public static final float CABLE_THICKNESS = 1.5f;
    public final BlockPos point1;
    public final BlockPos point2;
    public final boolean neighborConnection;
    public final boolean shouldRender;

    public WireConnection(WireManager.Conductor material, float lenght, BlockPos point1, BlockPos point2, boolean render, boolean neighborConnection) {
        this.material = material;
        this.lenght = lenght;
        this.point1 = point1;
        this.point2 = point2;
        this.shouldRender = render;
        this.neighborConnection = neighborConnection;
        this.resistance = material.resistivity * (lenght / 1.5f);
    }

    public void saveConnection(CompoundTag compound, int value) {
        compound.m_128405_("X1" + value, this.point1.m_123341_());
        compound.m_128405_("Y1" + value, this.point1.m_123342_());
        compound.m_128405_("Z1" + value, this.point1.m_123343_());
        compound.m_128405_("X2" + value, this.point2.m_123341_());
        compound.m_128405_("Y2" + value, this.point2.m_123342_());
        compound.m_128405_("Z2" + value, this.point2.m_123343_());
        compound.m_128350_("Lenght" + value, this.lenght);
        compound.m_128379_("NeighborConnection" + value, this.neighborConnection);
        compound.m_128379_("ShouldRender" + value, this.shouldRender);
        compound.m_128359_("Material" + value, this.material.name());
    }
}

