/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceActorInstance;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceRenderer;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PortableEnergyInterfaceMovement
implements MovementBehaviour {
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)PortableEnergyInterfaceBlock.f_52588_)).m_122436_()).m_82490_((double)1.85f);
    }

    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new PortableEnergyInterfaceActorInstance(materialManager, simulationWorld, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!ContraptionRenderDispatcher.canInstance()) {
            PortableEnergyInterfaceRenderer.renderInContraption(context, renderWorld, matrices, buffer);
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        boolean onCarriage = context.contraption instanceof CarriageContraption;
        if (!(onCarriage && context.motion.m_82553_() > 0.25 || this.findInterface(context, pos))) {
            context.data.m_128473_("WorkingPos");
        }
    }

    public void tick(MovementContext context) {
        boolean onCarriage;
        if (context.world.f_46443_) {
            PortableEnergyInterfaceMovement.getAnimation(context).tickChaser();
        }
        if (!(onCarriage = context.contraption instanceof CarriageContraption) || !(context.motion.m_82553_() > 0.25)) {
            if (context.world.f_46443_) {
                BlockPos pos = BlockPos.m_274446_((Position)context.position);
                if (!this.findInterface(context, pos)) {
                    this.reset(context);
                }
            } else if (context.data.m_128441_("WorkingPos")) {
                Optional<Direction> currentFacingIfValid;
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)context.data.m_128469_("WorkingPos"));
                Vec3 target = VecHelper.getCenterOf((Vec3i)pos);
                if (!context.stall && !onCarriage && context.position.m_82509_((Position)target, target.m_82554_(context.position.m_82549_(context.motion)))) {
                    context.stall = true;
                }
                if ((currentFacingIfValid = this.getCurrentFacingIfValid(context)).isPresent()) {
                    PortableEnergyInterfaceBlockEntity stationaryInterface = this.getStationaryInterfaceAt(context.world, pos, context.state, currentFacingIfValid.get());
                    if (stationaryInterface == null) {
                        this.reset(context);
                    } else {
                        if (stationaryInterface.getConnectedEntity() == null) {
                            stationaryInterface.startTransferringTo(context.contraption, stationaryInterface.getConnectionDistance());
                        }
                        boolean timerBelow = stationaryInterface.getTransferTimer() <= 4;
                        stationaryInterface.keepAlive = 2;
                        if (context.stall && timerBelow) {
                            context.stall = false;
                        }
                    }
                }
            }
        }
    }

    protected boolean findInterface(MovementContext context, BlockPos pos) {
        CarriageContraption cc;
        Contraption var4 = context.contraption;
        if (var4 instanceof CarriageContraption && !(cc = (CarriageContraption)var4).notInPortal()) {
            return false;
        }
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent()) {
            return false;
        }
        Direction currentFacing = currentFacingIfValid.get();
        PortableEnergyInterfaceBlockEntity psi = this.findStationaryInterface(context.world, pos, context.state, currentFacing);
        if (psi == null) {
            return false;
        }
        if (psi.isPowered()) {
            return false;
        }
        context.data.m_128365_("WorkingPos", (Tag)NbtUtils.m_129224_((BlockPos)psi.m_58899_()));
        if (!context.world.f_46443_) {
            Vec3 diff = VecHelper.getCenterOf((Vec3i)psi.m_58899_()).m_82546_(context.position);
            diff = VecHelper.project((Vec3)diff, (Vec3)Vec3.m_82528_((Vec3i)currentFacing.m_122436_()));
            float distance = (float)(diff.m_82553_() + (double)1.85f - 1.0);
            psi.startTransferringTo(context.contraption, distance);
        } else {
            context.data.m_128365_("ClientPrevPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            if (context.contraption instanceof CarriageContraption || context.contraption.entity.isStalled() || context.motion.m_82556_() == 0.0) {
                PortableEnergyInterfaceMovement.getAnimation(context).chase((double)(psi.getConnectionDistance() / 2.0f), 0.25, LerpedFloat.Chaser.LINEAR);
            }
        }
        return true;
    }

    public void stopMoving(MovementContext context) {
    }

    public void cancelStall(MovementContext context) {
        this.reset(context);
    }

    public void reset(MovementContext context) {
        context.data.m_128473_("ClientPrevPos");
        context.data.m_128473_("WorkingPos");
        context.stall = false;
        PortableEnergyInterfaceMovement.getAnimation(context).chase(0.0, 0.25, LerpedFloat.Chaser.LINEAR);
    }

    private PortableEnergyInterfaceBlockEntity findStationaryInterface(Level world, BlockPos pos, BlockState state, Direction facing) {
        for (int i = 0; i < 2; ++i) {
            PortableEnergyInterfaceBlockEntity interfaceAt = this.getStationaryInterfaceAt(world, pos.m_5484_(facing, i), state, facing);
            if (interfaceAt == null) continue;
            return interfaceAt;
        }
        return null;
    }

    private PortableEnergyInterfaceBlockEntity getStationaryInterfaceAt(Level world, BlockPos pos, BlockState state, Direction facing) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PortableEnergyInterfaceBlockEntity) {
            PortableEnergyInterfaceBlockEntity psi = (PortableEnergyInterfaceBlockEntity)te;
            BlockState blockState = world.m_8055_(pos);
            if (blockState.m_60734_() != state.m_60734_()) {
                return null;
            }
            if (blockState.m_61143_((Property)PortableEnergyInterfaceBlock.f_52588_) != facing.m_122424_()) {
                return null;
            }
            return psi.isPowered() ? null : psi;
        }
        return null;
    }

    private Optional<Direction> getCurrentFacingIfValid(MovementContext context) {
        Direction facingFromVector;
        Vec3 directionVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)PortableEnergyInterfaceBlock.f_52588_)).m_122436_());
        return (directionVec = (Vec3)context.rotation.apply(directionVec)).m_82554_(Vec3.m_82528_((Vec3i)(facingFromVector = Direction.m_122366_((double)directionVec.f_82479_, (double)directionVec.f_82480_, (double)directionVec.f_82481_)).m_122436_())) > 0.5 ? Optional.empty() : Optional.of(facingFromVector);
    }

    public static LerpedFloat getAnimation(MovementContext context) {
        Object var2 = context.temporaryData;
        if (var2 instanceof LerpedFloat) {
            LerpedFloat lf = (LerpedFloat)var2;
            return lf;
        }
        LerpedFloat nlf = LerpedFloat.linear();
        context.temporaryData = nlf;
        return nlf;
    }
}

