/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type;

import net.minecraft.nbt.CompoundTag;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class IdReferencePocket
extends AbstractPocket<IdReferencePocket> {
    public static String KEY = "id_reference";
    protected int referencedId;

    @Override
    public IdReferencePocket fromNbt(CompoundTag nbt) {
        super.fromNbt(nbt);
        this.referencedId = nbt.m_128451_("referenced_id");
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        nbt = super.toNbt(nbt);
        nbt.m_128405_("referenced_id", this.referencedId);
        return nbt;
    }

    @Override
    public AbstractPocket.AbstractPocketType<IdReferencePocket> getType() {
        return (AbstractPocket.AbstractPocketType)AbstractPocket.AbstractPocketType.ID_REFERENCE.get();
    }

    @Override
    public Pocket getReferencedPocket() {
        return this.getReferencedPocket(DimensionalRegistry.getPocketDirectory(this.getWorld()));
    }

    @Override
    public Pocket getReferencedPocket(PocketDirectory directory) {
        return directory.getPocket(this.referencedId);
    }

    public static IdReferencePocketBuilder builder() {
        return new IdReferencePocketBuilder((AbstractPocket.AbstractPocketType)AbstractPocket.AbstractPocketType.ID_REFERENCE.get());
    }

    public static class IdReferencePocketBuilder
    extends AbstractPocket.AbstractPocketBuilder<IdReferencePocketBuilder, IdReferencePocket> {
        private int referencedId = Integer.MIN_VALUE;

        protected IdReferencePocketBuilder(AbstractPocket.AbstractPocketType<IdReferencePocket> type) {
            super(type);
        }

        @Override
        public IdReferencePocket build() {
            IdReferencePocket pocket = (IdReferencePocket)super.build();
            pocket.referencedId = this.referencedId;
            return pocket;
        }

        @Override
        public IdReferencePocketBuilder fromNbt(CompoundTag nbt) {
            if (nbt.m_128425_("referenced_id", 3)) {
                this.referencedId = nbt.m_128451_("referenced_id");
            }
            return this;
        }

        @Override
        public CompoundTag toNbt(CompoundTag nbt) {
            if (this.referencedId != Integer.MIN_VALUE) {
                nbt.m_128405_("referenced_id", this.referencedId);
            }
            return nbt;
        }

        public IdReferencePocketBuilder referencedId(int referencedId) {
            this.referencedId = referencedId;
            return this;
        }
    }
}

