/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayConditionType;
import org.dimdev.dimdoors.world.decay.DecaySource;

public interface DecayCondition {
    public static final Codec<DecayCondition> CODEC = DecayConditionType.CODEC.dispatch("type", DecayCondition::getType, DecayConditionType::codec);
    public static final Codec<List<DecayCondition>> LIST_CODEC = Codec.either(CODEC, (Codec)CODEC.listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), conditions -> conditions.size() > 1 ? Either.right((Object)conditions) : Either.left((Object)((DecayCondition)conditions.get(0))));
    public static final DecayCondition NONE = new DecayCondition(){
        private static final String ID = "none";

        @Override
        public DecayConditionType<? extends DecayCondition> getType() {
            return (DecayConditionType)DecayConditionType.NONE_CONDITION_TYPE.get();
        }

        @Override
        public boolean test(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid, DecaySource source) {
            return false;
        }
    };

    public DecayConditionType<? extends DecayCondition> getType();

    public boolean test(Level var1, BlockPos var2, BlockState var3, BlockState var4, FluidState var5, DecaySource var6);

    default public Set<ResourceKey<Fluid>> constructApplicableFluids() {
        return Collections.emptySet();
    }

    default public Set<ResourceKey<Block>> constructApplicableBlocks() {
        return Collections.emptySet();
    }
}

