/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.network.packet.s2c.RenderBreakBlockS2CPacket;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.decay.DecayPattern;
import org.dimdev.dimdoors.world.decay.DecaySource;

public final class Decay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceKey<Level>, Set<DecayTask>> DECAY_QUEUE = new HashMap<ResourceKey<Level>, Set<DecayTask>>();

    public static void applySpreadDecay(ServerLevel world, BlockPos pos, RandomSource random, DecaySource source) {
        if (random.m_188500_() < DimensionalDoors.getConfig().getDecayConfig().decaySpreadChance) {
            BlockState origin = world.m_8055_(pos);
            int decayAmount = random.m_188503_(5) + 1;
            ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
            for (int i = 0; i < decayAmount; ++i) {
                Decay.decayBlock(world, pos.m_121945_((Direction)directions.remove(random.m_188503_(5 - i))), origin, source);
            }
        }
    }

    public static void decayBlock(ServerLevel world, BlockPos pos, BlockState origin, DecaySource source) {
        BlockState targetState = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        Collection<DecayPattern> patterns = DecayLoader.getInstance().getPatterns(targetState.m_222976_().m_203543_().get());
        if (patterns.isEmpty()) {
            patterns = DecayLoader.getInstance().getPatterns((ResourceKey<Fluid>)fluidState.m_76152_().m_205069_().m_205785_());
        }
        if (patterns.isEmpty()) {
            return;
        }
        for (DecayPattern pattern : patterns) {
            if (!world.m_201918_(pos) || !pattern.test((Level)world, pos, origin, targetState, fluidState, source)) continue;
            world.m_8795_(EntitySelector.m_20410_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.f_8906_).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(pos, 5)));
            world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)ModSoundEvents.TEARING.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            Decay.queueDecay(world, pos, origin, pattern, source, DimensionalDoors.getConfig().getDecayConfig().decayDelay);
            break;
        }
    }

    public static void queueDecay(ServerLevel world, BlockPos pos, BlockState origin, DecayPattern pattern, DecaySource source, int delay) {
        DecayTask task = new DecayTask(pos, origin, pattern, source, delay);
        if (delay <= 0) {
            task.process(world);
        } else {
            DECAY_QUEUE.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), k -> new HashSet()).add(task);
        }
    }

    public static void tick(ServerLevel world) {
        ResourceKey key = world.m_46472_();
        if (DECAY_QUEUE.containsKey(key)) {
            Set<DecayTask> tasks = DECAY_QUEUE.get(key);
            Set<DecayTask> tasksToRun = tasks.stream().filter(DecayTask::reduceDelayIsDone).collect(Collectors.toSet());
            tasks.removeAll(tasksToRun);
            tasksToRun.forEach(task -> task.process(world));
        }
    }

    public static class DecayLoader
    implements ResourceManagerReloadListener {
        private static final Logger LOGGER = LogManager.getLogger();
        private static final DecayLoader INSTANCE = new DecayLoader();
        private final Map<ResourceKey<Block>, List<DecayPattern>> blockPatterns = new HashMap<ResourceKey<Block>, List<DecayPattern>>();
        private final Map<ResourceKey<Fluid>, List<DecayPattern>> fluidPatterns = new HashMap<ResourceKey<Fluid>, List<DecayPattern>>();

        private DecayLoader() {
        }

        public static DecayLoader getInstance() {
            return INSTANCE;
        }

        public void m_6213_(ResourceManager manager) {
            this.blockPatterns.clear();
            CompletableFuture futurePatternList = ResourceUtil.loadResourcePathToCollection(manager, "decay_patterns", ".json", new ArrayList(), ResourceUtil.JSON_READER.andThenReader(this::loadPattern));
            for (DecayPattern pattern : (List)futurePatternList.join()) {
                for (ResourceKey<Block> resourceKey : pattern.constructApplicableBlocks()) {
                    this.blockPatterns.computeIfAbsent(resourceKey, b -> new ArrayList());
                    this.blockPatterns.get(resourceKey).add(pattern);
                }
                for (ResourceKey<Block> resourceKey : pattern.constructApplicableFluids()) {
                    this.fluidPatterns.computeIfAbsent(resourceKey, b -> new ArrayList());
                    this.fluidPatterns.get(resourceKey).add(pattern);
                }
            }
        }

        private DecayPattern loadPattern(JsonElement json, ResourceLocation ignored) {
            return (DecayPattern)((Pair)((DataResult)JsonOps.INSTANCE.withDecoder(DecayPattern.CODEC).apply(json)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))).getFirst();
        }

        public Collection<DecayPattern> getPatterns(Object object) {
            if (object instanceof ResourceKey) {
                ResourceKey key = (ResourceKey)object;
                if (key.m_135783_(Registries.f_256747_) && this.blockPatterns.containsKey(key)) {
                    return this.blockPatterns.get(key);
                }
                if (key.m_135783_(Registries.f_256808_) && this.fluidPatterns.containsKey(key)) {
                    return this.fluidPatterns.get(key);
                }
            }
            return Collections.emptyList();
        }

        public Collection<DecayPattern> getPatterns(ResourceKey<Fluid> fluid) {
            return this.fluidPatterns.getOrDefault(fluid, Collections.emptyList());
        }

        public Map<ResourceKey<Block>, List<DecayPattern>> getBlockPatterns() {
            return this.blockPatterns;
        }
    }

    private static class DecayTask {
        private final BlockPos pos;
        private final BlockState origin;
        private final DecayPattern processor;
        private final DecaySource source;
        private int delay;

        public DecayTask(BlockPos pos, BlockState origin, DecayPattern processor, DecaySource source, int delay) {
            this.pos = pos;
            this.origin = origin;
            this.processor = processor;
            this.source = source;
            this.delay = delay;
        }

        public boolean reduceDelayIsDone() {
            return --this.delay <= 0;
        }

        public void process(ServerLevel world) {
            BlockState targetBlock = world.m_8055_(this.pos);
            FluidState targetFluid = world.m_6425_(this.pos);
            world.m_8795_(EntitySelector.m_20410_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.f_8906_).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(this.pos, -1)));
            world.m_6263_(null, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), targetBlock.m_60827_().m_56775_(), SoundSource.BLOCKS, 0.5f, 1.0f);
            if (this.source.decayIntoWorldThread()) {
                if (DimensionalDoors.getConfig().getDecayConfig().decaysIntoAir) {
                    world.m_46597_(this.pos, Blocks.f_50016_.m_49966_());
                } else {
                    this.processor.process((Level)world, this.pos, this.origin, targetBlock, targetFluid, this.source);
                }
            } else {
                this.processor.process((Level)world, this.pos, this.origin, targetBlock, targetFluid, this.source);
            }
        }
    }
}

