/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import com.google.common.collect.Multimap;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.ReferenceSerializable;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.api.util.Weighted;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.TemplateUtils;
import org.dimdev.dimdoors.pockets.generator.ChunkGenerator;
import org.dimdev.dimdoors.pockets.generator.SchematicGenerator;
import org.dimdev.dimdoors.pockets.generator.VoidGenerator;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public abstract class PocketGenerator
implements Weighted<PocketGenerationContext>,
ReferenceSerializable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Registrar<PocketGeneratorType<? extends PocketGenerator>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("pocket_generator_type"), (Object[])new PocketGeneratorType[0]).build();
    public static final String RESOURCE_STARTING_PATH = "pockets/generator";
    private static final String defaultWeightEquation = "5";
    private static final int fallbackWeight = 5;
    protected final List<Modifier> modifierList = new ArrayList<Modifier>();
    private String resourceKey = null;
    private CompoundTag builderNbt;
    protected String weight = "5";
    protected Equation weightEquation;
    protected Boolean setupLoot;
    private final List<String> tags = new ArrayList<String>();

    public PocketGenerator() {
    }

    public PocketGenerator(String weight) {
        this.weight = weight;
        this.parseWeight();
    }

    public static PocketGenerator deserialize(Tag nbt, ResourceManager manager) {
        return switch (nbt.m_7060_()) {
            case 10 -> PocketGenerator.deserialize((CompoundTag)nbt, manager);
            case 8 -> ResourceUtil.loadReferencedResource(manager, RESOURCE_STARTING_PATH, nbt.m_7916_(), ResourceUtil.NBT_READER.andThenComposable(Tag2 -> PocketGenerator.deserialize(Tag2, manager)));
            default -> throw new RuntimeException(String.format("Unexpected NbtType %d!", nbt.m_6458_()));
        };
    }

    public static PocketGenerator deserialize(Tag nbt) {
        return PocketGenerator.deserialize(nbt, null);
    }

    public static PocketGenerator deserialize(CompoundTag nbt, ResourceManager manager) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        PocketGeneratorType type = (PocketGeneratorType)REGISTRY.get(id);
        if (type == null) {
            LOGGER.error("Could not deserialize PocketGenerator: " + nbt.toString());
            return null;
        }
        return type.fromNbt(nbt, manager);
    }

    public static PocketGenerator deserialize(CompoundTag nbt) {
        return PocketGenerator.deserialize(nbt, null);
    }

    public static Tag serialize(PocketGenerator pocketGenerator, boolean allowReference) {
        return pocketGenerator.toNbt(new CompoundTag(), allowReference);
    }

    public static Tag serialize(PocketGenerator pocketGenerator) {
        return PocketGenerator.serialize(pocketGenerator, false);
    }

    private void parseWeight() {
        try {
            this.weightEquation = Equation.parse(this.weight);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error("Could not parse weight equation \"" + this.weight + "\", defaulting to default weight equation \"5\"", (Throwable)e);
            try {
                this.weightEquation = Equation.newEquation(Equation.parse(defaultWeightEquation)::apply, stringBuilder -> stringBuilder.append(this.weight));
            }
            catch (Equation.EquationParseException equationParseException) {
                LOGGER.error("Could not parse default weight equation \"5\", defaulting to fallback weight \"5\"", (Throwable)equationParseException);
                this.weightEquation = Equation.newEquation(stringDoubleMap -> 5.0, stringBuilder -> stringBuilder.append(this.weight));
            }
        }
    }

    public PocketGenerator fromNbt(CompoundTag nbt, ResourceManager manager) {
        int i;
        ListTag modifiersNbt;
        if (nbt.m_128425_("builder", 10)) {
            this.builderNbt = nbt.m_128469_("builder");
        }
        this.weight = nbt.m_128441_("weight") ? nbt.m_128461_("weight") : defaultWeightEquation;
        this.parseWeight();
        if (nbt.m_128441_("setup_loot")) {
            this.setupLoot = nbt.m_128471_("setup_loot");
        }
        if (nbt.m_128441_("modifiers")) {
            modifiersNbt = nbt.m_128437_("modifiers", 10);
            for (i = 0; i < modifiersNbt.size(); ++i) {
                this.modifierList.add(Modifier.deserialize(modifiersNbt.m_128728_(i), manager));
            }
        }
        if (nbt.m_128441_("modifier_references")) {
            modifiersNbt = nbt.m_128437_("modifier_references", 8);
            for (Tag Tag2 : modifiersNbt) {
                this.modifierList.add(Modifier.deserialize(Tag2, manager));
            }
        }
        if (nbt.m_128441_("tags")) {
            ListTag nbtList = nbt.m_128437_("tags", 8);
            for (i = 0; i < nbtList.size(); ++i) {
                this.tags.add(nbtList.m_128778_(i));
            }
        }
        return this;
    }

    public PocketGenerator fromNbt(CompoundTag nbt) {
        return this.fromNbt(nbt, null);
    }

    public Tag toNbt(CompoundTag nbt, boolean allowReference) {
        if (allowReference && this.resourceKey != null) {
            return StringTag.m_129297_((String)this.resourceKey);
        }
        return this.toNbtInternal(nbt, allowReference);
    }

    protected CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        this.getType().toNbt(nbt);
        if (this.builderNbt != null) {
            nbt.m_128365_("builder", (Tag)this.builderNbt);
        }
        if (!this.weight.equals(defaultWeightEquation)) {
            nbt.m_128359_("weight", this.weight);
        }
        if (this.setupLoot != null) {
            nbt.m_128379_("setup_loot", this.setupLoot.booleanValue());
        }
        ListTag modifiersNbt = new ListTag();
        ListTag modifierReferences = new ListTag();
        block4: for (Modifier modifier : this.modifierList) {
            Tag modNbt = modifier.toNbt(new CompoundTag(), allowReference);
            switch (modNbt.m_7060_()) {
                case 10: {
                    modifiersNbt.add((Object)modNbt);
                    continue block4;
                }
                case 8: {
                    modifierReferences.add((Object)modNbt);
                    continue block4;
                }
            }
            throw new RuntimeException(String.format("Unexpected NbtType %d!", modNbt.m_6458_()));
        }
        if (modifiersNbt.size() > 0) {
            nbt.m_128365_("modifiers", (Tag)modifiersNbt);
        }
        if (modifierReferences.size() > 0) {
            nbt.m_128365_("modifier_references", (Tag)modifierReferences);
        }
        if (this.tags.size() > 0) {
            ListTag nbtList = new ListTag();
            for (String nbtStr : this.tags) {
                nbtList.add((Object)StringTag.m_129297_((String)nbtStr));
            }
            nbt.m_128365_("tags", (Tag)nbtList);
        }
        return nbt;
    }

    public Tag toNbt(CompoundTag nbt) {
        return this.toNbt(nbt, false);
    }

    @Override
    public void processFlags(Multimap<String, String> flags) {
        Collection reference = flags.get((Object)"reference");
        if (reference.stream().findFirst().map(string -> string.equals("local") || string.equals("global")).orElse(false).booleanValue()) {
            this.resourceKey = flags.get((Object)"resource_key").stream().findFirst().orElse(null);
        }
    }

    public abstract Pocket prepareAndPlacePocket(PocketGenerationContext var1, Pocket.PocketBuilder<?, ?> var2);

    public abstract PocketGeneratorType<? extends PocketGenerator> getType();

    public abstract String getKey();

    @Override
    public double getWeight(PocketGenerationContext parameters) {
        return this.weightEquation.apply(parameters.toVariableMap(new HashMap<String, Double>()));
    }

    public boolean isSetupLoot() {
        return this.setupLoot != null && this.setupLoot != false;
    }

    public void applyModifiers(PocketGenerationContext parameters, RiftManager manager) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, manager);
        }
    }

    public void applyModifiers(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, builder);
        }
    }

    public void setup(Pocket pocket, RiftManager manager, PocketGenerationContext parameters, boolean setupLootTables) {
        ServerLevel world = parameters.world();
        if (!(pocket instanceof LazyGenerationPocket) && setupLootTables) {
            pocket.getBlockEntities().forEach((blockPos, blockEntity) -> {
                Container inventory;
                if (blockEntity instanceof Container && (inventory = (Container)blockEntity).m_7983_() && (blockEntity instanceof ChestBlockEntity || blockEntity instanceof DispenserBlockEntity)) {
                    TemplateUtils.setupLootTable(world, blockEntity, inventory, LOGGER);
                    if (inventory.m_7983_()) {
                        LOGGER.error(", however Inventory is: empty!");
                    }
                }
            });
        }
        manager.getRifts().forEach(rift -> rift.getDestination().setLocation(new Location(world, rift.m_58899_())));
        TemplateUtils.registerRifts(manager.getRifts(), parameters.linkTo(), parameters.linkProperties(), pocket);
    }

    public RiftManager getRiftManager(Pocket pocket) {
        return new RiftManager(pocket);
    }

    public boolean checkTags(List<String> required, List<String> blackList, boolean exact) {
        if (exact && required.size() != this.tags.size()) {
            return false;
        }
        if (required != null) {
            for (String req : required) {
                if (this.tags.contains(req)) continue;
                return false;
            }
        }
        if (blackList != null) {
            for (String black : blackList) {
                if (!this.tags.contains(black)) continue;
                return false;
            }
        }
        return true;
    }

    public Pocket.PocketBuilder<?, ?> pocketBuilder(PocketGenerationContext parameters) {
        if (this.builderNbt == null) {
            return Pocket.builder().expand(this.getSize(parameters));
        }
        AbstractPocket.AbstractPocketBuilder<?, ?> abstractBuilder = AbstractPocket.deserializeBuilder(this.builderNbt);
        if (!(abstractBuilder instanceof Pocket.PocketBuilder)) {
            return Pocket.builder().expand(this.getSize(parameters));
        }
        Pocket.PocketBuilder builder = (Pocket.PocketBuilder)abstractBuilder;
        return builder.expand(this.getSize(parameters));
    }

    public abstract Vec3i getSize(PocketGenerationContext var1);

    public static interface PocketGeneratorType<T extends PocketGenerator> {
        public static final RegistrySupplier<PocketGeneratorType<PocketGenerator>> SCHEMATIC = PocketGeneratorType.register(DimensionalDoors.id("schematic"), SchematicGenerator::new);
        public static final RegistrySupplier<PocketGeneratorType<ChunkGenerator>> CHUNK = PocketGeneratorType.register(DimensionalDoors.id("chunk"), ChunkGenerator::new);
        public static final RegistrySupplier<PocketGeneratorType<VoidGenerator>> VOID = PocketGeneratorType.register(DimensionalDoors.id("void"), VoidGenerator::new);

        public PocketGenerator fromNbt(CompoundTag var1, ResourceManager var2);

        public CompoundTag toNbt(CompoundTag var1);

        public static void register() {
        }

        public static <U extends PocketGenerator> RegistrySupplier<PocketGeneratorType<U>> register(final ResourceLocation id, final Supplier<U> constructor) {
            return REGISTRY.register(id, () -> new PocketGeneratorType<U>(){

                @Override
                public PocketGenerator fromNbt(CompoundTag nbt, ResourceManager manager) {
                    return ((PocketGenerator)constructor.get()).fromNbt(nbt, manager);
                }

                @Override
                public CompoundTag toNbt(CompoundTag nbt) {
                    nbt.m_128359_("type", id.toString());
                    return nbt;
                }
            });
        }
    }
}

