/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network.packet.c2s;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.network.ServerPacketHandler;

public class HitBlockWithItemC2SPacket {
    public static final ResourceLocation ID = DimensionalDoors.id("hit_block_with_item");
    private InteractionHand hand;
    private BlockPos pos;
    private Direction direction;

    public HitBlockWithItemC2SPacket() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public HitBlockWithItemC2SPacket(InteractionHand hand, BlockPos pos, Direction direction) {
        this.hand = hand;
        this.pos = pos;
        this.direction = direction;
    }

    public HitBlockWithItemC2SPacket(FriendlyByteBuf buf) {
        this((InteractionHand)buf.m_130066_(InteractionHand.class), buf.m_130135_(), (Direction)buf.m_130066_(Direction.class));
    }

    public FriendlyByteBuf write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.hand);
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.direction);
        return buf;
    }

    public void apply(Supplier<NetworkManager.PacketContext> context) {
        ServerPacketHandler.get((ServerPlayer)context.get().getPlayer()).onAttackBlock(this);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

