/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.listener;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.dimdev.dimdoors.api.event.ChunkServedCallback;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.LazyCompatibleModifier;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class ChunkLoadListener
implements ChunkServedCallback {
    @Override
    public void onChunkServed(ServerLevel level, LevelChunk chunk) {
        if (level == null) {
            return;
        }
        if (!ModDimensions.isPocketDimension((Level)level)) {
            return;
        }
        Pocket pocket = DimensionalRegistry.getPocketDirectory((ResourceKey<Level>)level.m_46472_()).getPocketAt(chunk.m_7697_().m_45615_());
        if (!(pocket instanceof LazyGenerationPocket)) {
            return;
        }
        if (LazyPocketGenerator.currentlyGenerating) {
            LazyPocketGenerator.generationQueue.add(chunk);
        } else {
            LazyCompatibleModifier.runQueuedModifications(chunk);
            ((LazyGenerationPocket)pocket).chunkLoaded(chunk);
        }
    }
}

