/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.dimdev.dimdoors.item.RaycastHelper;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.jetbrains.annotations.Nullable;

public class RiftRemoverItem
extends Item {
    public static final String ID = "rift_remover";
    public static final ResourceLocation REMOVED_RIFT_LOOT_TABLE = DimensionalDoors.id("removed_rift");

    public RiftRemoverItem(Item.Properties settings) {
        super(settings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        ToolTipHelper.processTranslation(list, String.valueOf(this.m_41466_()) + ".info", new Object[0]);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hit = RaycastHelper.findDetachRift((Entity)player, RaycastHelper.DETACH);
        if (world.f_46443_) {
            if (!RaycastHelper.hitsDetachedRift((HitResult)hit, (BlockGetter)world)) {
                player.m_5661_((Component)Component.m_237115_((String)"tools.rift_miss"), true);
                RiftBlockEntity.showRiftCoreUntil = System.currentTimeMillis() + (long)DimensionalDoors.getConfig().getGraphicsConfig().highlightRiftCoreFor;
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (RaycastHelper.hitsDetachedRift((HitResult)hit, (BlockGetter)world)) {
            DetachedRiftBlockEntity rift = (DetachedRiftBlockEntity)world.m_7702_(hit.m_82425_());
            if (!Objects.requireNonNull(rift).closing) {
                rift.setClosing(true);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)ModSoundEvents.RIFT_CLOSE.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
                stack.m_41622_(10, (LivingEntity)player, a -> a.m_21190_(hand));
                BlockPos pos = hit.m_82425_();
                LootParams ctx = new LootParams.Builder((ServerLevel)world).m_287286_(LootContextParams.f_81461_, (Object)world.m_8055_(pos)).m_287286_(LootContextParams.f_81463_, (Object)stack).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287235_(LootContextParamSets.f_81421_);
                ((ServerLevel)world).m_7654_().m_278653_().m_278676_(REMOVED_RIFT_LOOT_TABLE).m_287195_(ctx).forEach(arg_0 -> RiftRemoverItem.lambda$use$1(world, (HitResult)hit, arg_0));
                player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".closing")), true);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".already_closing")), true);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private static /* synthetic */ void lambda$use$1(Level world, HitResult hit, ItemStack stack1) {
        Containers.m_18992_((Level)world, (double)((BlockHitResult)hit).m_82425_().m_123341_(), (double)((BlockHitResult)hit).m_82425_().m_123342_(), (double)((BlockHitResult)hit).m_82425_().m_123343_(), (ItemStack)stack1);
    }
}

