/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.mixin.accessor.ListTagAccessor;
import org.dimdev.dimdoors.network.ServerPacketHandler;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.jetbrains.annotations.Nullable;

public class RiftKeyItem
extends Item {
    public RiftKeyItem(Item.Properties settings) {
        super(settings);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (RiftKeyItem.isEmpty(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"item.dimdoors.rift_key.no_links"));
        } else if (context.m_7050_()) {
            for (UUID id : RiftKeyItem.getIds(stack)) {
                tooltip.add((Component)Component.m_237113_((String)(" " + id.toString())));
            }
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public boolean m_5812_(ItemStack stack) {
        return !RiftKeyItem.isEmpty(stack);
    }

    public int m_8105_(ItemStack stack) {
        return 30;
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        stack.m_41751_(this.m_7968_().m_41783_());
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41700_("Ids", (Tag)ListTagAccessor.createListTag(new ArrayList<Tag>(), (byte)11));
        return stack;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        Player player = context.m_43723_();
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (player != null && state.m_60734_() instanceof RiftProvider && player.m_6144_()) {
            Object riftBlockEntity = ((RiftProvider)state.m_60734_()).getRift(context.m_43725_(), context.m_8083_(), state);
            if (((RiftBlockEntity)riftBlockEntity).isDetached()) {
                return super.m_6225_(context);
            }
            EntranceRiftBlockEntity entranceRiftBlockEntity = (EntranceRiftBlockEntity)riftBlockEntity;
            Rift rift = DimensionalRegistry.getRiftRegistry().getRift(new Location((ResourceKey<Level>)entranceRiftBlockEntity.m_58904_().m_46472_(), entranceRiftBlockEntity.m_58899_()));
            if (entranceRiftBlockEntity.isLocked()) {
                if (RiftKeyItem.tryRemove(context.m_43722_(), rift.getId())) {
                    entranceRiftBlockEntity.setLocked(false);
                    entranceRiftBlockEntity.m_6596_();
                    EntityUtils.chat((Entity)player, (Component)Component.m_237115_((String)"rifts.unlocked"));
                    ServerPacketHandler.get((ServerPlayer)player).sync(context.m_43722_(), context.m_43724_());
                    return InteractionResult.SUCCESS;
                }
                EntityUtils.chat((Entity)player, (Component)Component.m_237115_((String)"rifts.cantUnlock"));
            } else {
                entranceRiftBlockEntity.setLocked(true);
                RiftKeyItem.add(context.m_43722_(), rift.getId());
                entranceRiftBlockEntity.m_6596_();
                EntityUtils.chat((Entity)player, (Component)Component.m_237115_((String)"rifts.locked"));
                ServerPacketHandler.get((ServerPlayer)player).sync(context.m_43722_(), context.m_43724_());
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    public static boolean tryRemove(ItemStack stack, UUID id) {
        IntArrayTag arrayTag = new IntArrayTag(UUIDUtil.m_235881_((UUID)id));
        return stack.m_41783_().m_128437_("Ids", 11).remove((Object)arrayTag);
    }

    public static void add(ItemStack stack, UUID id) {
        if (!RiftKeyItem.has(stack, id)) {
            stack.m_41784_().m_128437_("Ids", 11).add((Object)new IntArrayTag(UUIDUtil.m_235881_((UUID)id)));
        }
    }

    public static boolean has(ItemStack stack, UUID id) {
        return stack.m_41784_().m_128437_("Ids", 11).contains((Object)new IntArrayTag(UUIDUtil.m_235881_((UUID)id)));
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.m_41784_().m_128437_("Ids", 11).isEmpty();
    }

    public static List<UUID> getIds(ItemStack stack) {
        return stack.m_41784_().m_128437_("Ids", 11).stream().map(IntArrayTag.class::cast).map(IntArrayTag::m_128648_).map(UUIDUtil::m_235885_).toList();
    }
}

