/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.compat.rei.tesselating;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.compat.rei.TesselatingReiCompatClient;
import org.dimdev.dimdoors.compat.rei.tesselating.DefaultTesselatingDisplay;
import org.jetbrains.annotations.Nullable;

public class DefaultTesselatingCategory
implements DisplayCategory<DefaultTesselatingDisplay<?>> {
    public CategoryIdentifier<? extends DefaultTesselatingDisplay<?>> getCategoryIdentifier() {
        return TesselatingReiCompatClient.TESSELATING;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)ModBlocks.TESSELATING_LOOM.get()));
    }

    public Component getTitle() {
        return Component.m_237115_((String)"category.dimdoors.tesselating");
    }

    public List<Widget> setupDisplay(DefaultTesselatingDisplay<?> display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 60, startPoint.y + 18)).animationDurationTicks((double)display.getWeavingTime()));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 95, startPoint.y + 19)));
        List<InputIngredient<EntryStack<?>>> input = display.getInputIngredients(3, 3);
        ArrayList slots = Lists.newArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18)).markInput());
            }
        }
        for (InputIngredient<EntryStack<?>> ingredient : input) {
            ((Slot)slots.get(ingredient.getIndex())).entries((Collection)ingredient.get());
        }
        widgets.addAll(slots);
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 95, startPoint.y + 19)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        if (display.isShapeless()) {
            widgets.add(Widgets.createShapelessIcon((Rectangle)bounds));
        }
        return widgets;
    }

    @Nullable
    public DisplayMerger<DefaultTesselatingDisplay<?>> getDisplayMerger() {
        return new DisplayMerger<DefaultTesselatingDisplay<?>>(){

            public boolean canMerge(DefaultTesselatingDisplay<?> first, DefaultTesselatingDisplay<?> second) {
                if (!first.getCategoryIdentifier().equals(second.getCategoryIdentifier())) {
                    return false;
                }
                if (!this.equals(first.getOrganisedInputEntries(3, 3), second.getOrganisedInputEntries(3, 3))) {
                    return false;
                }
                if (!this.equals(first.getOutputEntries(), second.getOutputEntries())) {
                    return false;
                }
                if (first.isShapeless() != second.isShapeless()) {
                    return false;
                }
                if (first.getWidth() != second.getWidth()) {
                    return false;
                }
                return first.getHeight() == second.getHeight();
            }

            public int hashOf(DefaultTesselatingDisplay<?> display) {
                return display.getCategoryIdentifier().hashCode() * 31 * 31 * 31 + display.getOrganisedInputEntries(3, 3).hashCode() * 31 * 31 + display.getOutputEntries().hashCode();
            }

            private boolean equals(List<EntryIngredient> l1, List<EntryIngredient> l2) {
                if (l1.size() != l2.size()) {
                    return false;
                }
                Iterator<EntryIngredient> it1 = l1.iterator();
                Iterator<EntryIngredient> it2 = l2.iterator();
                while (it1.hasNext() && it2.hasNext()) {
                    if (it1.next().equals((Object)it2.next())) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

