/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.compat.rei.decay;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.world.item.ItemStack;
import org.dimdev.dimdoors.compat.rei.TesselatingReiCompatClient;
import org.dimdev.dimdoors.world.decay.DecayPattern;

public record DefaultDecaysIntoDisplay<S>(S key, List<EntryIngredient> ingredients) implements Display
{
    public static <T> DefaultDecaysIntoDisplay<T> of(T object, List<DecayPattern> patterns) {
        List<EntryIngredient> ingredients = patterns.stream().map(pattern -> pattern.willBecome(object)).filter(Objects::nonNull).map(DefaultDecaysIntoDisplay::toEntryStack).map(EntryIngredient::of).toList();
        return new DefaultDecaysIntoDisplay<T>(object, ingredients);
    }

    public static EntryStack<?> toEntryStack(Object object) {
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)stack);
        }
        if (object instanceof FluidStack) {
            FluidStack stack = (FluidStack)object;
            return EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)stack);
        }
        return EntryStack.empty();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.ingredients;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.ingredients;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return TesselatingReiCompatClient.DECAYS_INTO;
    }

    public List<EntryStack<?>> getDecayEntries() {
        return this.ingredients.stream().flatMap(a -> a.stream()).toList();
    }
}

