/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.client.RiftCurves;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class RiftCrackRenderer {
    public static void drawCrack(Matrix4f model, VertexConsumer vc, float riftRotation, RiftCurves.PolygonInfo poly, double size, long riftRandom) {
        double scale = size / (double)(poly.maxX - poly.minX);
        double offsetX = (double)(poly.maxX + poly.minX) / 2.0;
        double offsetY = (double)(poly.maxY + poly.minY) / 2.0;
        double offsetZ = 0.0;
        float motionMagnitude = 0.6f;
        float motionSpeed = 0.014f;
        int jCount = 10;
        float time = (float)((Util.m_137574_() + riftRandom) % 2000000L) * motionSpeed;
        double[] jitters = new double[jCount];
        double jitterScale = DimensionalDoors.getConfig().getGraphicsConfig().riftJitter * size * size * size / 2000.0;
        double xJitter = jitterScale * Math.sin((double)(1.1f * time) * size) * Math.sin(0.8f * time);
        double yJitter = jitterScale * Math.sin((double)(1.2f * time) * size) * Math.sin(0.9f * time);
        double zJitter = jitterScale * Math.sin((double)(1.3f * time) * size) * Math.sin(0.7f * time);
        for (int i = 0; i < jCount; ++i) {
            jitters[i] = Math.sin((1.0f + (float)i / 10.0f) * time) * Math.cos(1.0f - (float)i / 10.0f * time) * (double)motionMagnitude;
        }
        ArrayList<RiftCurves.Point> points = poly.points;
        int pointsSize = points.size();
        for (int i = 0; i < pointsSize; i += 3) {
            RiftCurves.Point p = points.get(i);
            RiftCrackRenderer.renderPoint(vc, model, points.get(i + 0), jCount, offsetX, offsetY, offsetZ, xJitter, yJitter, zJitter, scale, riftRotation, jitters, false);
            RiftCrackRenderer.renderPoint(vc, model, points.get(i + 1), jCount, offsetX, offsetY, offsetZ, xJitter, yJitter, zJitter, scale, riftRotation, jitters, false);
            RiftCrackRenderer.renderPoint(vc, model, points.get(i + 2), jCount, offsetX, offsetY, offsetZ, xJitter, yJitter, zJitter, scale, riftRotation, jitters, true);
        }
    }

    public static void renderPoint(VertexConsumer vc, Matrix4f model, RiftCurves.Point p, int jCount, double offsetX, double offsetY, double offsetZ, double xJitter, double yJitter, double zJitter, double scale, double riftRotation, double[] jitters, boolean twice) {
        int jIndex = Math.abs((p.x + p.y) * (p.x + p.y + 1) / 2 + p.y);
        double x = ((double)p.x + jitters[(jIndex + 1) % jCount] - offsetX) * Math.cos(Math.toRadians(riftRotation)) - jitters[(jIndex + 2) % jCount] * Math.sin(Math.toRadians(riftRotation));
        double y = (double)p.y + jitters[jIndex % jCount] - offsetY;
        double z = ((double)p.x + jitters[(jIndex + 2) % jCount] - offsetZ) * Math.sin(Math.toRadians(riftRotation)) + jitters[(jIndex + 2) % jCount] * Math.cos(Math.toRadians(riftRotation));
        vc.m_252986_(model, (float)((x *= scale) + xJitter), (float)((y *= scale) + yJitter), (float)((z *= scale) + zJitter)).m_85950_(0.08f, 0.08f, 0.08f, 0.3f).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(0).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        if (twice) {
            vc.m_252986_(model, (float)(x + xJitter), (float)(y + yJitter), (float)(z + zJitter)).m_85950_(0.08f, 0.08f, 0.08f, 0.3f).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(0).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        }
    }
}

