/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.utils.GameInstance;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.DimensionalDoorsClient;
import org.dimdev.dimdoors.client.MyRenderLayer;
import org.dimdev.dimdoors.client.RiftCrackRenderer;
import org.dimdev.dimdoors.client.RiftCurves;
import org.dimdev.dimdoors.client.tesseract.Tesseract;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.rift.targets.IdMarker;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;

@OnlyIn(value=Dist.CLIENT)
public class DetachedRiftBlockEntityRenderer
implements BlockEntityRenderer<DetachedRiftBlockEntity> {
    public static final ResourceLocation TESSERACT_PATH = DimensionalDoors.id("textures/other/tesseract.png");
    private static final RGBA DEFAULT_COLOR = new RGBA(1.0f, 0.5f, 1.0f, 1.0f);
    private static final Tesseract TESSERACT = new Tesseract();
    private static final RiftCurves.PolygonInfo CURVE = RiftCurves.CURVES.get(1);

    public void render(DetachedRiftBlockEntity rift, float tickDelta, PoseStack matrices, MultiBufferSource vcs, int breakProgress, int alpha) {
        VirtualTarget virtualTarget;
        if (GameInstance.getClient().f_91074_ != null && GameInstance.getClient().f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModItems.RIFT_CONFIGURATION_TOOL.get()) && (virtualTarget = rift.getData().getDestination()) instanceof IdMarker) {
            IdMarker idMarker = (IdMarker)virtualTarget;
            matrices.m_85836_();
            matrices.m_85837_(0.5, 0.5, 0.5);
            GameInstance.getClient().f_91062_.m_272077_((Component)Component.m_237113_((String)String.valueOf(idMarker.getId())), 0.0f, 0.0f, -1, false, matrices.m_85850_().m_252922_(), vcs, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            matrices.m_85849_();
        }
        if (DimensionalDoors.getConfig().getGraphicsConfig().showRiftCore || RiftBlockEntity.showRiftCoreUntil - System.currentTimeMillis() >= 0L) {
            this.renderTesseract(vcs.m_6299_(DimensionalDoorsClient.detector.shaderPackOn() ? RenderType.m_110458_((ResourceLocation)TESSERACT_PATH) : MyRenderLayer.TESSERACT), rift, matrices, tickDelta);
        }
        this.renderCrack(vcs.m_6299_(RenderType.m_110458_((ResourceLocation)TESSERACT_PATH)), matrices, rift);
    }

    private void renderCrack(VertexConsumer vc, PoseStack matrices, DetachedRiftBlockEntity rift) {
        matrices.m_85836_();
        matrices.m_85837_(0.5, 1.5, 0.5);
        RiftCrackRenderer.drawCrack(matrices.m_85850_().m_252922_(), vc, 0.0f, RiftCurves.CURVES.get(rift.getCurveID()), DimensionalDoors.getConfig().getGraphicsConfig().riftSize * (double)rift.size / 150.0, 0L);
        matrices.m_85849_();
    }

    private void renderTesseract(VertexConsumer vc, DetachedRiftBlockEntity rift, PoseStack matrices, float tickDelta) {
        double radian = this.nextAngle(rift, tickDelta) * (Math.PI / 180);
        RGBA color = rift.getColor();
        if (Objects.equals(color, RGBA.NONE)) {
            color = DEFAULT_COLOR;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        matrices.m_85841_(0.25f, 0.25f, 0.25f);
        TESSERACT.draw(matrices.m_85850_().m_252922_(), vc, color, radian);
        matrices.m_85849_();
    }

    private double nextAngle(DetachedRiftBlockEntity rift, float tickDelta) {
        rift.renderAngle = (rift.renderAngle + (double)(5.0f * tickDelta)) % 360.0;
        return rift.renderAngle;
    }
}

