/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RotatedLocation;
import org.dimdev.dimdoors.api.util.forge.TeleportUtilImpl;
import org.dimdev.dimdoors.entity.stat.ModStats;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.world.ModDimensions;

public final class TeleportUtil {
    public static <E extends Entity> E teleport(E entity, Level world, BlockPos pos, float yaw) {
        return TeleportUtil.teleport(entity, world, Vec3.m_82539_((Vec3i)pos), yaw);
    }

    public static <E extends Entity> E teleport(E entity, Level world, Vec3 pos, float yaw) {
        return TeleportUtil.teleport(entity, world, pos, new Rotations((float)entity.m_20185_(), yaw, 0.0f), entity.m_20184_());
    }

    public static Vec3 clampToWorldBorder(Vec3 original, WorldBorder border) {
        double newX = original.f_82479_;
        double newZ = original.f_82481_;
        double size = border.m_61959_() - 1.0;
        double northBound = border.m_61956_() + 1.0;
        double southBound = border.m_61958_() - 1.0;
        double westBound = border.m_61955_() + 1.0;
        double eastBound = border.m_61957_() - 1.0;
        if (newZ < northBound) {
            newZ = northBound + Math.abs(newZ % size) + 1.0;
        } else if (newZ > southBound) {
            newZ = southBound - Math.abs(newZ % size) - 1.0;
        }
        if (newX < westBound) {
            newX = westBound + Math.abs(newX % size) + 1.0;
        } else if (newX > eastBound) {
            newX = eastBound - Math.abs(newX % size) - 1.0;
        }
        return new Vec3(newX, original.f_82480_, newZ);
    }

    public static <E extends Entity> E teleport(E entity, Level world, Vec3 pos, Rotations angle, Vec3 velocity) {
        if (world.m_5776_()) {
            throw new UnsupportedOperationException("Only supported on ServerWorld");
        }
        pos = TeleportUtil.clampToWorldBorder(pos, world.m_6857_());
        float yaw = Mth.m_14177_((float)angle.m_123157_());
        float pitch = Mth.m_14036_((float)Mth.m_14177_((float)angle.m_123156_()), (float)-90.0f, (float)90.0f);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ChunkPos chunkPos = new ChunkPos(new BlockPos(new Vec3i((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_)));
            ((ServerLevel)world).m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)entity.m_19879_());
            entity.m_8127_();
            if (entity.m_9236_().m_46472_().equals(world.m_46472_())) {
                serverPlayer.f_8906_.m_9774_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), yaw, pitch);
            } else {
                entity = TeleportUtil.teleport(entity, (ServerLevel)world, new PortalInfo(pos, velocity, yaw, pitch));
            }
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity.m_19879_(), velocity));
            ((ExtendedServerPlayNetworkHandler)serverPlayer.f_8906_).getDimDoorsPacketHandler().syncPocketAddonsIfNeeded(world, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            if (world.m_46472_() == ModDimensions.DUNGEON) {
                serverPlayer.m_36220_(ModStats.TIMES_BEEN_TO_DUNGEON);
            }
        } else if (entity.m_9236_().m_46472_().equals(world.m_46472_())) {
            entity.m_7678_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), yaw, pitch);
        } else {
            entity = TeleportUtil.teleport(entity, (ServerLevel)world, new PortalInfo(pos, velocity, yaw, pitch));
        }
        entity.m_20256_(velocity);
        return entity;
    }

    public static <E extends Entity> E teleport(E entity, Level world, BlockPos pos, Rotations angle, Vec3 velocity) {
        if (world.m_5776_()) {
            throw new UnsupportedOperationException("Only supported on ServerWorld");
        }
        return TeleportUtil.teleport(entity, world, Vec3.m_82539_((Vec3i)pos), angle, velocity);
    }

    public static ServerPlayer teleport(ServerPlayer player, Location location) {
        return TeleportUtil.teleport(player, (Level)DimensionalDoors.getWorld(location.world), location.pos, 0.0f);
    }

    public static ServerPlayer teleport(ServerPlayer player, RotatedLocation location) {
        return TeleportUtil.teleport(player, (Level)DimensionalDoors.getWorld((ResourceKey<Level>)location.world), location.pos, (float)((int)location.yaw));
    }

    public static <E extends Entity> E teleportRandom(E entity, Level world, double y) {
        double scale = ThreadLocalRandom.current().nextGaussian() * (double)ThreadLocalRandom.current().nextInt(90);
        return TeleportUtil.teleport(entity, world, entity.m_20182_().m_82492_(0.0, entity.m_20186_(), 0.0).m_82520_(0.0, y, 0.0).m_82542_(scale, 1.0, scale), entity.m_146908_());
    }

    public static <E extends Entity> E teleportUntargeted(E entity, Level world) {
        double actualScale = entity.m_9236_().m_6042_().f_63859_() / world.m_6042_().f_63859_();
        return TeleportUtil.teleport(entity, world, entity.m_20182_().m_82542_(actualScale, 1.0, actualScale), entity.m_146908_());
    }

    public static <E extends Entity> E teleportUntargeted(E entity, Level world, double y) {
        double actualScale = entity.m_9236_().m_6042_().f_63859_() / world.m_6042_().f_63859_();
        return TeleportUtil.teleport(entity, world, entity.m_20182_().m_82492_(0.0, entity.m_20182_().m_7098_(), 0.0).m_82520_(0.0, y, 0.0).m_82542_(actualScale, 1.0, actualScale), entity.m_146908_());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends Entity> E teleport(E entity, ServerLevel world, PortalInfo portalInfo) {
        void var2_2;
        void var1_1;
        return TeleportUtilImpl.teleport(entity, (ServerLevel)var1_1, (PortalInfo)var2_2);
    }
}

