/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerHandler {
    public static final SetRestrictedField<BiConsumer<Level, BlockPos>> SOLIDIFY_CONCRETE_POWDER = SetRestrictedField.common();
    public static List<Pair<TagKey<Fluid>, ChemthrowerEffect>> effectList = new ArrayList<Pair<TagKey<Fluid>, ChemthrowerEffect>>();
    public static HashSet<TagKey<Fluid>> flammableList = new HashSet();

    public static void registerEffect(TagKey<Fluid> fluidTag, ChemthrowerEffect effect) {
        effectList.add((Pair<TagKey<Fluid>, ChemthrowerEffect>)Pair.of(fluidTag, (Object)effect));
    }

    public static ChemthrowerEffect getEffect(Fluid fluid) {
        if (fluid != null) {
            for (Pair<TagKey<Fluid>, ChemthrowerEffect> entry : effectList) {
                if (!fluid.m_205067_((TagKey)entry.getFirst())) continue;
                return (ChemthrowerEffect)entry.getSecond();
            }
        }
        return null;
    }

    public static void registerFlammable(TagKey<Fluid> fluidTag) {
        flammableList.add(fluidTag);
    }

    public static boolean isFlammable(Fluid fluid) {
        if (fluid != null) {
            for (TagKey<Fluid> predicate : flammableList) {
                if (!fluid.m_205067_(predicate)) continue;
                return true;
            }
        }
        return false;
    }

    public static abstract class ChemthrowerEffect {
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            this.applyToEntity(target, shooter, thrower, fluid.getFluid());
        }

        public abstract void applyToEntity(LivingEntity var1, @Nullable Player var2, ItemStack var3, Fluid var4);

        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            this.applyToBlock(world, mop, shooter, thrower, fluid.getFluid());
        }

        public abstract void applyToBlock(Level var1, HitResult var2, @Nullable Player var3, ItemStack var4, Fluid var5);
    }

    public static class ChemthrowerEffect_RandomTeleport
    extends ChemthrowerEffect_Damage {
        float chance;

        public ChemthrowerEffect_RandomTeleport(DamageSource source, float damage, float chance) {
            super(source, damage);
            this.chance = chance;
        }

        @Override
        public void applyToEntity(LivingEntity target, Player shooter, ItemStack thrower, Fluid fluid) {
            super.applyToEntity(target, shooter, thrower, fluid);
            if (ApiUtils.RANDOM.nextFloat() < this.chance) {
                double x = target.m_20185_() - 8.0 + (double)ApiUtils.RANDOM.nextInt(17);
                double y = target.m_20186_() + (double)ApiUtils.RANDOM.nextInt(8);
                double z = target.m_20189_() - 8.0 + (double)ApiUtils.RANDOM.nextInt(17);
                if (!target.m_9236_().m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_280296_()) {
                    EntityTeleportEvent.EnderEntity event = new EntityTeleportEvent.EnderEntity(target, x, y, z);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    target.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    target.m_9236_().m_7785_(target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
        }
    }

    public static class ChemthrowerEffect_Extinguish
    extends ChemthrowerEffect {
        private static DamageSource getPlayerDrownDamage(Player player, DamageSources sources) {
            DamageSource drownSource = sources.m_269063_();
            if (player == null) {
                return drownSource;
            }
            return new DamageSource(drownSource.m_269150_(), (Entity)player);
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            if (target.m_6060_()) {
                target.m_20095_();
            }
            if ((target instanceof Blaze || target instanceof EnderMan) && target.m_6469_(ChemthrowerEffect_Extinguish.getPlayerDrownDamage(shooter, target.m_269291_()), 3.0f)) {
                target.f_19802_ = (int)((double)target.f_19802_ * 0.75);
            }
        }

        @Override
        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            if (!(mop instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult rtr = (BlockHitResult)mop;
            BlockPos pos = rtr.m_82425_();
            SOLIDIFY_CONCRETE_POWDER.getValue().accept(world, pos);
            pos = rtr.m_82425_().m_121945_(rtr.m_82434_());
            Block b = world.m_8055_(pos).m_60734_();
            if (b instanceof FireBlock) {
                world.m_7471_(pos, false);
            }
        }
    }

    public static class ChemthrowerEffect_Potion
    extends ChemthrowerEffect_Damage {
        MobEffectInstance[] potionEffects;
        float[] effectChances;

        public ChemthrowerEffect_Potion(DamageSource source, float damage, MobEffectInstance ... effects) {
            super(source, damage);
            this.potionEffects = effects;
            this.effectChances = new float[this.potionEffects.length];
            Arrays.fill(this.effectChances, 1.0f);
        }

        public ChemthrowerEffect_Potion(DamageSource source, float damage, MobEffect potion, int duration, int amplifier) {
            this(source, damage, new MobEffectInstance(potion, duration, amplifier));
        }

        public ChemthrowerEffect_Potion setEffectChance(int effectIndex, float chance) {
            if (effectIndex >= 0 && effectIndex < this.effectChances.length) {
                this.effectChances[effectIndex] = chance;
            }
            return this;
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            super.applyToEntity(target, shooter, thrower, fluid);
            if (this.potionEffects != null && this.potionEffects.length > 0) {
                for (int iEffect = 0; iEffect < this.potionEffects.length; ++iEffect) {
                    if (!(target.m_217043_().m_188501_() < this.effectChances[iEffect])) continue;
                    MobEffectInstance e = this.potionEffects[iEffect];
                    MobEffectInstance newEffect = new MobEffectInstance(e.m_19544_(), e.m_19557_(), e.m_19564_());
                    newEffect.setCurativeItems(new ArrayList(e.getCurativeItems()));
                    target.m_7292_(newEffect);
                }
            }
        }
    }

    public static class ChemthrowerEffect_Damage
    extends ChemthrowerEffect {
        DamageSource source;
        float damage;

        public ChemthrowerEffect_Damage(DamageSource source, float damage) {
            this.source = source;
            this.damage = damage;
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            if (this.source != null && target.m_6469_(this.source, this.damage)) {
                target.f_19802_ = (int)((double)target.f_19802_ * 0.75);
                if (this.source.m_269533_(DamageTypeTags.f_268745_) && !target.m_5825_()) {
                    target.m_20254_(fluid.m_205067_(Tags.Fluids.GASEOUS) ? 2 : 5);
                }
            }
        }

        @Override
        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
        }
    }
}

