/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.icon.XaeroIconAtlasManager;
import xaero.map.misc.Misc;

public class WaypointSymbolCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private static final int ICON_WIDTH = 64;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private Minecraft mc = Minecraft.m_91087_();
    private XaeroIcon deathSymbolTexture;
    private final Map<String, XaeroIcon> charSymbols = new HashMap<String, XaeroIcon>();
    private XaeroIconAtlasManager iconManager;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private XaeroIconAtlas lastAtlas;

    public XaeroIcon getDeathSymbolTexture(GuiGraphics guiGraphics) {
        if (this.deathSymbolTexture == null) {
            this.createDeathSymbolTexture(guiGraphics);
        }
        return this.deathSymbolTexture;
    }

    private void createDeathSymbolTexture(GuiGraphics guiGraphics) {
        this.deathSymbolTexture = this.createCharSymbol(guiGraphics, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XaeroIcon getSymbolTexture(GuiGraphics guiGraphics, String c) {
        XaeroIcon icon;
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            icon = this.charSymbols.get(c);
        }
        if (icon == null) {
            icon = this.createCharSymbol(guiGraphics, false, c);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XaeroIcon createCharSymbol(GuiGraphics guiGraphics, boolean death, String c) {
        if (this.iconManager == null) {
            OpenGLException.checkGLError();
            int maxTextureSize = GlStateManager._getInteger((int)3379);
            OpenGLException.checkGLError();
            int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
            this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
            OpenGLException.checkGLError();
            GlStateManager._deleteTexture((int)this.atlasRenderFramebuffer.getFramebufferTexture());
            OpenGLException.checkGLError();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
            this.iconManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        }
        XaeroIconAtlas atlas = this.iconManager.getCurrentAtlas();
        XaeroIcon icon = atlas.createIcon();
        this.atlasRenderFramebuffer.m_83947_(false);
        GlStateManager._viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
        this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
        this.atlasRenderFramebuffer.m_83949_();
        if (this.lastAtlas != atlas) {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)Minecraft.f_91002_);
            this.lastAtlas = atlas;
        }
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, 64.0f, 64.0f, 0.0f, -1.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (VertexSorting)VertexSorting.f_276633_);
        PoseStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_166856_();
        matrixStack.m_252880_(2.0f, 2.0f, 0.0f);
        if (!death) {
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            guiGraphics.m_280488_(this.mc.f_91062_, c, 0, 0, -1);
        } else {
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            RenderSystem.setShaderColor((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            guiGraphics.m_280398_(minimapTextures, 1, 1, 0, 0.0f, 78.0f, 9, 9, 256, 256);
            RenderSystem.setShaderColor((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            guiGraphics.m_280398_(minimapTextures, 0, 0, 0, 0.0f, 78.0f, 9, 9, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrixStack.m_85849_();
        Misc.minecraftOrtho(this.mc, false);
        shaderMatrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        this.atlasRenderFramebuffer.m_83970_();
        this.atlasRenderFramebuffer.bindDefaultFramebuffer(this.mc);
        GlStateManager._viewport((int)0, (int)0, (int)this.mc.m_91268_().m_85441_(), (int)this.mc.m_91268_().m_85442_());
        if (death) {
            this.deathSymbolTexture = icon;
        } else {
            Map<String, XaeroIcon> map = this.charSymbols;
            synchronized (map) {
                this.charSymbols.put(c, icon);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChars() {
        Map<String, XaeroIcon> map = this.charSymbols;
        synchronized (map) {
            this.charSymbols.clear();
        }
        this.lastAtlas = null;
        this.deathSymbolTexture = null;
        if (this.iconManager != null) {
            this.iconManager.clearAtlases();
            this.atlasRenderFramebuffer.setFramebufferTexture(0);
        }
    }
}

