/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.generation.large_generator;

import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.blocks.electricity.base.KineticElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.generation.large_generator.StatorBlock;
import com.drmangotea.tfmg.blocks.electricity.generation.large_generator.StatorBlockEntity;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RotorBlockEntity
extends KineticElectricBlockEntity {
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;
    int FEProduction = 0;
    List<BlockPos> stators = new ArrayList<BlockPos>();
    public static final Map<Direction.Axis, Map<StatorOffset, BlockState>> statorPosition = RotorBlockEntity.setStatorPositons();

    public RotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.0078125, LerpedFloat.Chaser.EXP);
    }

    public void setFEProduction() {
        float modifier = TFMGConfigs.server().machines.largeGeneratorFeModifier.getF();
        if (this.stators.size() != 8) {
            this.FEProduction = 0;
            return;
        }
        this.FEProduction = (int)((Math.log((double)Math.abs(this.getSpeed()) - 68.25) / Math.log(1.026) - 22.0) * (double)modifier);
    }

    @Override
    public int voltageGeneration() {
        if (this.stators.size() != 8) {
            return 0;
        }
        if (this.speed == 0.0f) {
            return 0;
        }
        return Math.min(5000, this.FEProduction * 7);
    }

    @Override
    public void tick() {
        super.tick();
        this.manageRotation();
        this.setFEProduction();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findStators();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.findStators();
    }

    @Override
    public int FECapacity() {
        return 10000;
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.setFEProduction();
    }

    public void findStators() {
        Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        Map<StatorOffset, BlockState> position = statorPosition.get(axis);
        this.stators = new ArrayList<BlockPos>();
        position.forEach((offset, state) -> {
            BlockEntity patt3608$temp;
            BlockPos pos = this.m_58899_().m_121945_(offset.direction1);
            if (offset.direction2.isPresent()) {
                pos = pos.m_121945_(offset.direction2.get());
            }
            if ((patt3608$temp = this.f_58857_.m_7702_(pos)) instanceof StatorBlockEntity) {
                StatorBlockEntity be = (StatorBlockEntity)patt3608$temp;
                if (be.rotor == null || be.rotor == this.m_58899_()) {
                    this.stators.add(pos);
                    this.f_58857_.m_7731_(pos, state, 2);
                    be.rotor = this.m_58899_();
                } else {
                    this.stators = new ArrayList<BlockPos>();
                    this.setFEProduction();
                    this.needsNetworkUpdate();
                    this.needsVoltageUpdate();
                }
            } else {
                this.stators = new ArrayList<BlockPos>();
                this.setFEProduction();
                this.needsNetworkUpdate();
                this.needsVoltageUpdate();
            }
        });
    }

    @Override
    public int FEProduction() {
        return this.FEProduction;
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.GENERATOR.get());
    }

    public void manageRotation() {
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction.m_122434_() != this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
    }

    public static Map<Direction.Axis, Map<StatorOffset, BlockState>> setStatorPositons() {
        HashMap<Direction.Axis, Map<StatorOffset, BlockState>> statorPositions = new HashMap<Direction.Axis, Map<StatorOffset, BlockState>>();
        BlockState defaultState = TFMGBlocks.STATOR.getDefaultState();
        BlockState cornerState = (BlockState)defaultState.m_61124_(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.CORNER));
        BlockState horizontal = (BlockState)defaultState.m_61124_(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.CORNER_HORIZONTAL));
        BlockState sideState = (BlockState)defaultState.m_61124_(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.SIDE));
        BlockState cornerFlipped = (BlockState)cornerState.m_61124_((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(false));
        BlockState sideFlipped = (BlockState)sideState.m_61124_((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(false));
        HashMap<StatorOffset, BlockState> xPos = new HashMap<StatorOffset, BlockState>();
        xPos.put(RotorBlockEntity.pos(Direction.UP), (BlockState)sideFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.DOWN));
        xPos.put(RotorBlockEntity.pos(Direction.DOWN), (BlockState)sideFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.UP));
        xPos.put(RotorBlockEntity.pos(Direction.NORTH), (BlockState)sideFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.SOUTH));
        xPos.put(RotorBlockEntity.pos(Direction.SOUTH), (BlockState)sideFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.NORTH));
        xPos.put(RotorBlockEntity.pos(Direction.UP, Direction.NORTH), (BlockState)cornerState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.EAST));
        xPos.put(RotorBlockEntity.pos(Direction.UP, Direction.SOUTH), (BlockState)cornerState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.WEST));
        xPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.NORTH), (BlockState)cornerFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.EAST));
        xPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.SOUTH), (BlockState)cornerFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.WEST));
        HashMap<StatorOffset, BlockState> yPos = new HashMap<StatorOffset, BlockState>();
        yPos.put(RotorBlockEntity.pos(Direction.EAST), (BlockState)sideState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.WEST));
        yPos.put(RotorBlockEntity.pos(Direction.WEST), (BlockState)sideState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.EAST));
        yPos.put(RotorBlockEntity.pos(Direction.SOUTH), (BlockState)sideState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.NORTH));
        yPos.put(RotorBlockEntity.pos(Direction.NORTH), (BlockState)sideState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.SOUTH));
        yPos.put(RotorBlockEntity.pos(Direction.NORTH, Direction.WEST), (BlockState)horizontal.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.NORTH));
        yPos.put(RotorBlockEntity.pos(Direction.SOUTH, Direction.EAST), (BlockState)horizontal.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.SOUTH));
        yPos.put(RotorBlockEntity.pos(Direction.SOUTH, Direction.WEST), (BlockState)horizontal.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.WEST));
        yPos.put(RotorBlockEntity.pos(Direction.NORTH, Direction.EAST), (BlockState)horizontal.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.EAST));
        HashMap<StatorOffset, BlockState> zPos = new HashMap<StatorOffset, BlockState>();
        zPos.put(RotorBlockEntity.pos(Direction.UP), (BlockState)sideState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.DOWN));
        zPos.put(RotorBlockEntity.pos(Direction.DOWN), (BlockState)sideState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.UP));
        zPos.put(RotorBlockEntity.pos(Direction.WEST), (BlockState)sideFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.EAST));
        zPos.put(RotorBlockEntity.pos(Direction.EAST), (BlockState)sideFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.WEST));
        zPos.put(RotorBlockEntity.pos(Direction.UP, Direction.WEST), (BlockState)cornerState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.UP));
        zPos.put(RotorBlockEntity.pos(Direction.UP, Direction.EAST), (BlockState)cornerState.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.SOUTH));
        zPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.WEST), (BlockState)cornerFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.UP));
        zPos.put(RotorBlockEntity.pos(Direction.DOWN, Direction.EAST), (BlockState)cornerFlipped.m_61124_((Property)StatorBlock.f_52588_, (Comparable)Direction.SOUTH));
        statorPositions.put(Direction.Axis.X, xPos);
        statorPositions.put(Direction.Axis.Y, yPos);
        statorPositions.put(Direction.Axis.Z, zPos);
        return statorPositions;
    }

    private static StatorOffset pos(Direction dir1) {
        return new StatorOffset(dir1, Optional.empty());
    }

    private static StatorOffset pos(Direction dir1, Direction dir2) {
        return new StatorOffset(dir1, Optional.of(dir2));
    }

    private static class StatorOffset {
        public final Direction direction1;
        public final Optional<Direction> direction2;

        public StatorOffset(Direction dir1, Optional<Direction> dir2) {
            this.direction1 = dir1;
            this.direction2 = dir2;
        }
    }
}

