/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.StorageMod;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final List<String> defaultMultiblocks = Arrays.asList("");
    private static final Config INSTANCE = new Config();
    public boolean onlyTrims;
    public int invRange;
    public int invConnectorMax = 0;
    public int wirelessRange;
    public Set<Block> multiblockInvs = new HashSet<Block>();
    public int advWirelessRange;
    public int wirelessTermBeaconLvl;
    public int wirelessTermBeaconLvlDim;
    public int invLinkBeaconLvl;
    public int invLinkBeaconLvlDim;
    public int invDupScanSize;
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    public static Config get() {
        return INSTANCE;
    }

    private void load(ModConfig modConfig) {
        if (modConfig.getType() == ModConfig.Type.SERVER) {
            this.onlyTrims = (Boolean)Config.SERVER.onlyTrimsConnect.get();
            this.invRange = (Integer)Config.SERVER.inventoryConnectorRange.get() * (Integer)Config.SERVER.inventoryConnectorRange.get();
            this.invConnectorMax = (Integer)Config.SERVER.inventoryCableConnectorMaxCables.get();
            this.wirelessRange = (Integer)Config.SERVER.wirelessRange.get();
            this.advWirelessRange = (Integer)Config.SERVER.advWirelessRange.get();
            this.wirelessTermBeaconLvl = (Integer)Config.SERVER.wirelessTermBeaconLvl.get();
            this.wirelessTermBeaconLvlDim = (Integer)Config.SERVER.wirelessTermBeaconLvlDim.get();
            this.invLinkBeaconLvl = (Integer)Config.SERVER.invLinkBeaconLvl.get();
            this.invLinkBeaconLvlDim = (Integer)Config.SERVER.invLinkBeaconLvlDim.get();
            this.invDupScanSize = (Integer)Config.SERVER.invDupScanSize.get();
        } else if (modConfig.getType() == ModConfig.Type.COMMON) {
            this.multiblockInvs = ((List)Config.COMMON.multiblockInvs.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).filter(e -> e != null && e != Blocks.f_50016_).collect(Collectors.toSet());
        }
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        StorageMod.LOGGER.info("Loaded Tom's Simple Storage config file {}", (Object)configEvent.getConfig().getFileName());
        this.load(configEvent.getConfig());
    }

    @SubscribeEvent
    public void onFileChange(ModConfigEvent.Reloading configEvent) {
        StorageMod.LOGGER.info("Tom's Simple Storage config just got changed on the file system!");
        this.load(configEvent.getConfig());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public ForgeConfigSpec.IntValue inventoryConnectorRange;
        public ForgeConfigSpec.IntValue inventoryCableConnectorMaxCables;
        public ForgeConfigSpec.IntValue wirelessRange;
        public ForgeConfigSpec.BooleanValue onlyTrimsConnect;
        public ForgeConfigSpec.IntValue advWirelessRange;
        public ForgeConfigSpec.IntValue wirelessTermBeaconLvl;
        public ForgeConfigSpec.IntValue wirelessTermBeaconLvlDim;
        public ForgeConfigSpec.IntValue invLinkBeaconLvl;
        public ForgeConfigSpec.IntValue invLinkBeaconLvlDim;
        public ForgeConfigSpec.IntValue invDupScanSize;

        private Server(ForgeConfigSpec.Builder builder) {
            this.inventoryConnectorRange = builder.comment("Inventory Connector Range").translation("tomsstorage.config.inventory_connector_range").defineInRange("inventoryConnectorRange", 16, 4, 256);
            this.onlyTrimsConnect = builder.comment("Only Allow Trims to Connect Inventories").translation("tomsstorage.config.only_trims_connect").define("onlyTrimsConnect", false);
            this.inventoryCableConnectorMaxCables = builder.comment("Inventory Cable Connector Maximum number of cables").translation("tomsstorage.config.inv_cable_connector_max_scan").defineInRange("invCableConnectorMaxScanSize", 2048, 16, Integer.MAX_VALUE);
            this.wirelessRange = builder.comment("Wireless terminal reach").translation("tomsstorage.config.wireless_reach").defineInRange("wirelessReach", 16, 4, 64);
            this.advWirelessRange = builder.comment("Wireless terminal reach").translation("tomsstorage.config.adv_wireless_range").defineInRange("advWirelessRange", 64, 16, 512);
            this.wirelessTermBeaconLvl = builder.comment(new String[]{"Adv Wireless terminal requied beacon level for infinite range", "Value of 0 only requires a single beacon block nearby", "Value of -1 disables this feature entirely"}).translation("tomsstorage.config.adv_wireless_beacon_lvl").defineInRange("wirelessTermBeaconLvl", 1, -1, 4);
            this.wirelessTermBeaconLvlDim = builder.comment(new String[]{"Adv Wireless terminal requied beacon level for cross dimensional access", "Value of 0 only requires a single beacon block nearby", "Value of -1 disables this feature entirely"}).translation("tomsstorage.config.adv_wireless_beacon_lvl_dim").defineInRange("wirelessTermBeaconLvlDim", 4, -1, 4);
            this.invLinkBeaconLvl = builder.comment(new String[]{"Inventory Cable Connector requied beacon level for inventory linking", "Value of 0 only requires a single beacon block", "Value of -1 disables this feature entirely"}).translation("tomsstorage.config.inv_link_beacon_lvl").defineInRange("invLinkBeaconLvl", 1, -1, 4);
            this.invLinkBeaconLvlDim = builder.comment(new String[]{"Inventory Cable Connector requied beacon level for cross dimensional access", "Value of 0 only requires a single beacon block", "Value of -1 disables this feature entirely"}).translation("tomsstorage.config.inv_link_beacon_lvl_dim").defineInRange("invLinkBeaconLvlDim", 2, -1, 4);
            this.invDupScanSize = builder.comment(new String[]{"Inventory Connector duplicate finder max slot count", "Value of 0 only disables"}).translation("tomsstorage.config.inv_dup_scan_size").defineInRange("invDupScanSize", 100, 0, Integer.MAX_VALUE);
        }
    }

    public static class Common {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> multiblockInvs;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"IMPORTANT NOTICE:", "THIS IS ONLY THE COMMON CONFIG. It does not contain all the values adjustable for Tom's Simple Storage", "The settings have been moved to toms_storage-server.toml", "That file is PER WORLD, meaning you have to go into 'saves/<world name>/serverconfig' to adjust it. Those changes will then only apply for THAT WORLD.", "You can then take that config file and put it in the 'defaultconfigs' folder to make it apply automatically to all NEW worlds you generate FROM THERE ON.", "This may appear confusing to many of you, but it is a new sensible way to handle configuration, because the server configuration is synced when playing multiplayer."}).define("importantInfo", true);
            this.multiblockInvs = builder.comment("List of multiblock inventory blocks").translation("tomsstorage.config.multiblock_inv").defineList("multiblockInv", defaultMultiblocks, s -> true);
        }
    }
}

