/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class JEIPotionMix {
    private final ItemStack potionInput;
    private final ItemStack potionOutput;
    private final List<ItemStack> mix1;
    private final List<ItemStack> mix2;
    private final ExtendedPotionMix original;

    @NotNull
    public static Collection<JEIPotionMix> createFromMix(@NotNull ExtendedPotionMix mix) {
        List<ItemStack> in1 = mix.reagent1.map(Ingredient::m_43908_).stream().flatMap(Arrays::stream).map(ItemStack::m_41777_).peek(s -> s.m_41764_(mix.reagent1Count)).filter(s -> !s.m_41619_()).collect(Collectors.toList());
        List<ItemStack> in2 = mix.reagent2.map(Ingredient::m_43908_).stream().flatMap(Arrays::stream).map(ItemStack::m_41777_).peek(s -> s.m_41764_(mix.reagent2Count)).filter(s -> !s.m_41619_()).collect(Collectors.toList());
        ArrayList<JEIPotionMix> recipes = new ArrayList<JEIPotionMix>(3);
        recipes.add(JEIPotionMix.build(mix, Items.f_42589_, mix.input.get(), mix.output.get(), in1, in2));
        if (mix.output.get().m_43488_().stream().noneMatch(s -> s.m_19544_().m_19483_() != MobEffectCategory.HARMFUL)) {
            recipes.add(JEIPotionMix.build(mix, Items.f_42739_, mix.input.get(), mix.output.get(), in1, in2));
            recipes.add(JEIPotionMix.build(mix, Items.f_42736_, mix.input.get(), mix.output.get(), in1, in2));
        }
        return recipes;
    }

    @NotNull
    private static JEIPotionMix build(ExtendedPotionMix mix, Item base, @NotNull Potion in, @NotNull Potion out, List<ItemStack> in1, List<ItemStack> in2) {
        ItemStack potionIn = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)base), (Potion)in);
        ItemStack potionOut = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)base), (Potion)out);
        return new JEIPotionMix(mix, potionIn, in1, in2, potionOut);
    }

    private JEIPotionMix(ExtendedPotionMix original, ItemStack potionInput, List<ItemStack> mix1, List<ItemStack> mix2, ItemStack potionOutput) {
        this.original = original;
        this.potionInput = potionInput;
        this.mix1 = mix1;
        this.mix2 = mix2;
        this.potionOutput = potionOutput;
    }

    public ExtendedPotionMix getOriginal() {
        return this.original;
    }

    public ItemStack getPotionInput() {
        return this.potionInput;
    }

    public List<ItemStack> getMix1() {
        return this.mix1;
    }

    public List<ItemStack> getMix2() {
        return this.mix2;
    }

    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }
}

