/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.command.arguments.MinionArgument;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.player.lord.skills.LordSkills;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerMinionController
implements INBTSerializable<CompoundTag> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Random rng = new Random();
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final UUID lordID;
    private int maxMinions;
    @Nullable
    private IPlayableFaction<?> faction;
    @NotNull
    private @NotNull MinionInfo @NotNull [] minions = new MinionInfo[0];
    @NotNull
    private @NotNull Optional<Integer> @NotNull [] minionTokens = new Optional[0];

    @NotNull
    public static List<IMinionTask<?, ?>> getAvailableTasks(@NotNull ILordPlayer player) {
        if (player.getLordFaction() == null) {
            return new ArrayList();
        }
        return RegUtil.values(ModRegistries.MINION_TASKS).stream().filter(t -> t.isAvailable(player.getLordFaction(), player)).collect(Collectors.toList());
    }

    public PlayerMinionController(@NotNull MinecraftServer server, @NotNull UUID lordID) {
        this.server = server;
        this.lordID = lordID;
    }

    public void activateTask(int minionID, @NotNull IMinionTask<?, MinionData> task) {
        if (!this.getLordPlayer().map(Entity::m_5833_).orElse(false).booleanValue()) {
            if (minionID >= this.minions.length) {
                LOGGER.warn("Trying to activate a task for a non-existent minion {}", (Object)minionID);
            } else if (minionID < 0) {
                for (MinionInfo i : this.minions) {
                    if (i.data.isTaskLocked()) continue;
                    this.activateTask(i, task);
                }
            } else {
                this.activateTask(this.minions[minionID], task);
            }
        }
    }

    public void checkInMinion(int id, int token) {
        MinionInfo i = this.getMinionInfo(id, token);
        if (i != null) {
            i.checkin();
        }
    }

    @Nullable
    public <T extends MinionData> T checkoutMinion(int id, int token, @NotNull MinionEntity<T> entity) {
        ResourceKey dimension;
        int entityId;
        MinionInfo i = this.getMinionInfo(id, token);
        if (i != null && i.checkout(entityId = entity.m_19879_(), (ResourceKey<Level>)(dimension = entity.m_9236_().m_46472_()))) {
            return (T)i.data;
        }
        return null;
    }

    public Optional<Integer> claimMinionSlot(int id) {
        if (id < this.minionTokens.length && this.minionTokens[id].isEmpty() && !this.minions[id].isStillRecovering()) {
            int t = this.rng.nextInt();
            this.minionTokens[id] = Optional.of(t);
            return this.minionTokens[id];
        }
        return Optional.empty();
    }

    public void contactMinion(int slot, Consumer<MinionEntity<?>> entityConsumer) {
        if (slot < this.minions.length) {
            this.getMinionEntity(this.minions[slot]).ifPresent(entityConsumer);
        }
    }

    @NotNull
    public <T> Optional<T> contactMinionData(int id, @NotNull Function<MinionData, T> function) {
        if (id >= 0 && id < this.minions.length) {
            return Optional.of(function.apply(this.minions[id].data));
        }
        return Optional.empty();
    }

    public void contactMinions(Consumer<MinionEntity<?>> entityConsumer) {
        for (MinionInfo m : this.minions) {
            this.getMinionEntity(m).ifPresent(entityConsumer);
        }
    }

    @Nullable
    public MinionEntity<?> createMinionEntityAtPlayer(int id, @NotNull Player p) {
        assert (id >= 0);
        EntityType<? extends MinionEntity<?>> type = this.minions[id].minionType;
        if (type != null) {
            return Helper.createEntity(type, p.m_20193_()).map(m -> {
                if (this.faction == null || this.faction.isEntityOfFaction((PathfinderMob)m)) {
                    LOGGER.warn("Specified minion entity is of wrong faction. This: {} Minion: {}", this.faction, (Object)m.getFaction());
                    m.m_146870_();
                    return null;
                }
                m.claimMinionSlot(id, this);
                m.m_20359_((Entity)p);
                p.m_9236_().m_7967_((Entity)m);
                this.activateTask(id, (IMinionTask)MinionTasks.STAY.get());
                return m;
            }).orElse(null);
        }
        LOGGER.warn("Cannot create minion because type does not exist");
        return null;
    }

    public int createNewMinionSlot(@NotNull MinionData data, EntityType<? extends MinionEntity<?>> minionType) {
        int i = this.minions.length;
        if (i < this.maxMinions) {
            MinionInfo[] n = Arrays.copyOf(this.minions, i + 1);
            Optional<Integer>[] t = Arrays.copyOf(this.minionTokens, i + 1);
            n[i] = new MinionInfo(i, data, minionType);
            t[i] = Optional.empty();
            this.minions = n;
            this.minionTokens = t;
            return i;
        }
        return -1;
    }

    public void deserializeNBT(@NotNull CompoundTag nbt) {
        IFaction<?> f = VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(nbt.m_128461_("faction")));
        if (!(f instanceof IPlayableFaction)) {
            this.maxMinions = 0;
            return;
        }
        this.faction = (IPlayableFaction)f;
        this.maxMinions = nbt.m_128451_("max_minions");
        ListTag data = nbt.m_128437_("data", 10);
        MinionInfo[] infos = new MinionInfo[data.size()];
        Optional[] tokens = new Optional[data.size()];
        for (Tag n : data) {
            CompoundTag tag = (CompoundTag)n;
            int id = tag.m_128451_("id");
            MinionData d = MinionData.fromNBT(tag);
            ResourceLocation entityTypeID = new ResourceLocation(tag.m_128461_("entity_type"));
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(entityTypeID)) {
                LOGGER.warn("Cannot find saved minion type {}. Aborting controller load", (Object)entityTypeID);
                this.minions = new MinionInfo[0];
                this.minionTokens = new Optional[0];
                return;
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeID);
            MinionInfo i = new MinionInfo(id, d, type);
            i.deathCooldown = tag.m_128451_("death_timer");
            infos[id] = i;
            if (tag.m_128425_("token", 99)) {
                tokens[id] = Optional.of(tag.m_128451_("token"));
                continue;
            }
            tokens[id] = Optional.empty();
        }
        this.minions = infos;
        this.minionTokens = tokens;
    }

    @NotNull
    public Collection<Integer> getCallableMinions() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < this.minions.length; ++i) {
            if (this.minions[i].isStillRecovering()) continue;
            ids.add(i);
        }
        return ids;
    }

    @NotNull
    public List<MutableComponent> getRecoveringMinionNames() {
        return Arrays.stream(this.minions).filter(MinionInfo::isStillRecovering).map(i -> i.data).map(MinionData::getFormattedName).collect(Collectors.toList());
    }

    @NotNull
    public UUID getUUID() {
        return this.lordID;
    }

    @NotNull
    public Collection<Integer> getUnclaimedMinions() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < this.minionTokens.length; ++i) {
            if (!this.minionTokens[i].isEmpty() || this.minions[i].isStillRecovering()) continue;
            ids.add(i);
        }
        return ids;
    }

    public boolean hasFreeMinionSlot() {
        return this.minions.length < this.maxMinions;
    }

    public boolean hasMinions() {
        return this.minions.length > 0;
    }

    public void markDeadAndReleaseMinionSlot(int id, int token) {
        MinionInfo i = this.getMinionInfo(id, token);
        if (i != null) {
            i.checkin();
            i.deathCooldown = 20 * (Integer)VampirismConfig.BALANCE.miDeathRecoveryTime.get();
            this.getLord().ifPresent(player -> player.getLordFaction().getPlayerCapability(player.getPlayer()).map(IFactionPlayer::getSkillHandler).ifPresent(s -> {
                if (s.isSkillEnabled((ISkill)LordSkills.MINION_RECOVERY.get())) {
                    i.deathCooldown = (int)((double)i.deathCooldown * 0.8);
                }
            }));
            if (id < this.minionTokens.length) {
                this.minionTokens[id] = Optional.empty();
            }
        }
    }

    public boolean recallMinion(int id) {
        if (id >= 0 && id < this.minions.length) {
            return this.recallMinion(this.minions[id]);
        }
        return false;
    }

    @NotNull
    public Collection<Integer> recallMinions(boolean force) {
        ArrayList<Integer> ids = new ArrayList<Integer>(this.minions.length);
        for (MinionInfo minion : this.minions) {
            if (!force && minion.data.isTaskLocked() || !this.recallMinion(minion)) continue;
            ids.add(minion.minionID);
        }
        return ids;
    }

    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("max_minions", this.maxMinions);
        if (this.faction != null) {
            nbt.m_128359_("faction", this.faction.getID().toString());
        }
        ListTag data = new ListTag();
        for (MinionInfo i : this.minions) {
            CompoundTag d = i.data.serializeNBT();
            d.m_128405_("death_timer", i.deathCooldown);
            d.m_128405_("id", i.minionID);
            if (i.minionType != null) {
                d.m_128359_("entity_type", RegUtil.id(i.minionType).toString());
            }
            this.minionTokens[i.minionID].ifPresent(t -> d.m_128405_("token", t.intValue()));
            data.add((Object)d);
        }
        nbt.m_128365_("data", (Tag)data);
        return nbt;
    }

    public void setMaxMinions(@Nullable IPlayableFaction<?> faction, int newCount) {
        assert (newCount >= 0);
        if (this.faction != null && faction != this.faction) {
            LOGGER.warn("Changing player minion controller faction");
            this.contactMinions(MinionEntity::recallMinion);
            this.minions = new MinionInfo[0];
            this.minionTokens = new Optional[0];
            this.faction = faction;
            this.maxMinions = this.faction == null ? 0 : newCount;
        } else {
            this.faction = faction;
            if (newCount >= this.maxMinions) {
                this.maxMinions = newCount;
            } else {
                LOGGER.debug("Reducing minion count from {} to {}", (Object)this.maxMinions, (Object)newCount);
                while (this.minions.length > newCount) {
                    int nL = this.minions.length - 1;
                    this.contactMinion(nL, MinionEntity::recallMinion);
                    MinionInfo[] n = Arrays.copyOf(this.minions, nL);
                    Optional<Integer>[] t = Arrays.copyOf(this.minionTokens, nL);
                    this.minions = n;
                    this.minionTokens = t;
                }
            }
        }
    }

    public void tick() {
        for (MinionInfo i : this.minions) {
            if (i.deathCooldown > 0) {
                --i.deathCooldown;
                if (i.deathCooldown != 0) continue;
                i.data.setHealth(i.data.getMaxHealth());
                this.getLordPlayer().ifPresent(player -> player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.minion.can_respawn", (Object[])new Object[]{i.data.getFormattedName()}), true));
                continue;
            }
            IMinionTask.IMinionTaskDesc<MinionData> taskDesc = i.data.getCurrentTaskDesc();
            this.tickTask(taskDesc.getTask(), taskDesc, i);
        }
    }

    private void activateTask(@NotNull MinionInfo info, @NotNull IMinionTask<?, MinionData> task) {
        @Nullable ? desc = task.activateTask(this.getLordPlayer().orElse(null), this.getMinionEntity(info).orElse(null), info.data);
        if (desc == null) {
            this.getLordPlayer().ifPresent(player -> player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.minion.could_not_activate"), false));
        } else {
            MinionData d = info.data;
            d.switchTask(d.getCurrentTaskDesc().getTask(), d.getCurrentTaskDesc(), (IMinionTask.IMinionTaskDesc<MinionData>)desc);
            this.contactMinion(info.minionID, MinionEntity::onTaskChanged);
        }
    }

    @NotNull
    private LazyOptional<? extends ILordPlayer> getLord() {
        return this.getLordPlayer().map(FactionPlayerHandler::getOpt).orElse(LazyOptional.empty());
    }

    @NotNull
    private Optional<Player> getLordPlayer() {
        return Optional.ofNullable(this.server.m_6846_().m_11259_(this.lordID));
    }

    @NotNull
    private Optional<MinionEntity<?>> getMinionEntity(@NotNull MinionInfo info) {
        if (info.isActive()) {
            assert (info.dimension != null);
            ServerLevel w = this.server.m_129880_(info.dimension);
            if (w != null) {
                Entity e = w.m_6815_(info.entityId);
                if (e instanceof MinionEntity) {
                    return Optional.of((MinionEntity)e);
                }
                LOGGER.warn("Retrieved entity is not a minion entity {}", (Object)e);
            }
        }
        return Optional.empty();
    }

    @Nullable
    private MinionInfo getMinionInfo(int id, int token) {
        assert (this.minions.length == this.minionTokens.length);
        if (id < this.minions.length && this.minionTokens[id].map(t -> t == token).orElse(false).booleanValue()) {
            return this.minions[id];
        }
        return null;
    }

    private boolean recallMinion(@NotNull MinionInfo i) {
        this.contactMinion(i.minionID, MinionEntity::recallMinion);
        if (i.isActive()) {
            LOGGER.debug("Minion still active after recall");
            i.checkin();
        }
        this.minionTokens[i.minionID] = Optional.empty();
        return !i.isStillRecovering();
    }

    private <Q extends IMinionTask.IMinionTaskDesc<MinionData>, T extends IMinionTask<Q, MinionData>> void tickTask(@NotNull T task, IMinionTask.IMinionTaskDesc<MinionData> desc, @NotNull MinionInfo info) {
        if (info.isActive()) {
            task.tickActive(desc, () -> this.getMinionEntity(info).map(m -> m), (MinionData)info.data);
        } else {
            task.tickBackground(desc, (MinionData)info.data);
        }
    }

    public Collection<MinionArgument.MinionId> getMinionIdForName(String playerName) {
        return Arrays.stream(this.minions).map(i -> new MinionArgument.MinionId(playerName, i.minionID, i.data.getFormattedName().getString())).collect(Collectors.toList());
    }

    private static class MinionInfo {
        final int minionID;
        @NotNull
        final MinionData data;
        @Nullable
        final EntityType<? extends MinionEntity<?>> minionType;
        int entityId = -1;
        int deathCooldown = 0;
        @Nullable
        ResourceKey<Level> dimension;

        private MinionInfo(int id, @NotNull MinionData data, @Nullable EntityType<? extends MinionEntity<?>> minionType) {
            this.minionID = id;
            this.data = data;
            this.minionType = minionType;
        }

        void checkin() {
            if (this.entityId == -1) {
                LOGGER.debug("Closing minion data for inactive minion");
            }
            this.entityId = -1;
            this.dimension = null;
        }

        boolean checkout(int entityId, ResourceKey<Level> dim) {
            if (this.entityId != -1 || this.isStillRecovering()) {
                return false;
            }
            this.entityId = entityId;
            this.dimension = dim;
            return true;
        }

        boolean isActive() {
            return this.entityId != -1;
        }

        boolean isStillRecovering() {
            return this.deathCooldown > 0;
        }
    }
}

