/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.SpawnHelper;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.MotherBlockEntity;
import de.teamlapen.vampirism.blocks.mother.MotherTreeStructure;
import de.teamlapen.vampirism.blocks.mother.RemainsBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VulnerableRemainsBlockEntity
extends BlockEntity {
    public static final int MAX_HEALTH = 100;
    private BlockPos motherPos;
    private int health = 100;
    @Nullable
    private UUID dummy_entity_id;
    private boolean spawnedBackup;
    private long lastDamage = 0L;
    private boolean firstTick = true;

    public static void serverTick(ServerLevel level, BlockPos blockPos, BlockState blockState, VulnerableRemainsBlockEntity e) {
        if (e.firstTick) {
            e.firstTick = false;
            e.getMother().ifPresent(mother -> {
                mother.updateFightStatus();
                e.checkDummyEntity(level, blockPos);
            });
        } else if (level.m_46467_() % 128L == 3L) {
            e.checkDummyEntity(level, blockPos);
            if (e.lastDamage - level.m_46467_() > 3600L) {
                e.health = Math.min(e.health + 10, 100);
                if (e.health == 100) {
                    e.spawnedBackup = false;
                }
            }
        }
    }

    public VulnerableRemainsBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.VULNERABLE_CURSED_ROOTED_DIRT.get(), pos, state);
    }

    private void destroyVulnerability() {
        this.f_58857_.m_46597_(this.f_58858_, ((RemainsBlock)ModBlocks.INCAPACITATED_VULNERABLE_REMAINS.get()).m_49966_());
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.health = tag.m_128451_("health");
        this.lastDamage = tag.m_128454_("lastDamage");
        if (tag.m_128441_("motherPos")) {
            int[] pos = tag.m_128465_("motherPos");
            this.motherPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
        if (tag.m_128425_("dummy_entity_id", 11)) {
            this.dummy_entity_id = tag.m_128342_("dummy_entity_id");
        }
    }

    public void onDamageDealt(DamageSource src, double damage) {
        Entity entity;
        this.health -= (int)damage;
        if (this.f_58857_ != null) {
            this.lastDamage = this.f_58857_.m_46467_();
        }
        if (this.health <= 0) {
            this.destroyVulnerability();
        }
        if ((entity = src.m_7639_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.getMother().ifPresent(mother -> mother.onVulnerabilityHit(entity2, this.health <= 0));
        }
        if (!this.spawnedBackup && this.health <= 50 && (entity = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            this.checkDummyEntity(serverLevel, this.f_58858_).spawnDefenders();
            this.spawnedBackup = true;
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("health", this.health);
        tag.m_128356_("lastDamage", this.lastDamage);
        if (this.motherPos != null) {
            tag.m_128385_("motherPos", new int[]{this.motherPos.m_123341_(), this.motherPos.m_123342_(), this.motherPos.m_123343_()});
        }
        if (this.dummy_entity_id != null) {
            tag.m_128362_("dummy_entity_id", this.dummy_entity_id);
        }
    }

    private VulnerableRemainsDummyEntity checkDummyEntity(ServerLevel level, BlockPos blockPos) {
        if (this.dummy_entity_id != null) {
            Entity e = level.m_8791_(this.dummy_entity_id);
            if (e instanceof VulnerableRemainsDummyEntity) {
                VulnerableRemainsDummyEntity dummy = (VulnerableRemainsDummyEntity)e;
                return dummy;
            }
            this.dummy_entity_id = null;
        }
        return SpawnHelper.spawn(ModEntities.VULNERABLE_REMAINS_DUMMY, (Level)level, entity -> {
            entity.m_146884_(Vec3.m_82512_((Vec3i)blockPos).m_82520_(0.0, (double)-0.51f, 0.0));
            entity.setOwnerLocation(blockPos);
            this.dummy_entity_id = entity.m_20148_();
        });
    }

    public int getHealth() {
        return this.health;
    }

    public Optional<MotherBlockEntity> getMother() {
        if (this.f_58857_ != null) {
            return MotherTreeStructure.findMother((LevelAccessor)this.f_58857_, this.m_58899_()).map(p -> this.f_58857_.m_7702_((BlockPos)p.getKey())).filter(MotherBlockEntity.class::isInstance).map(MotherBlockEntity.class::cast);
        }
        return Optional.empty();
    }

    public void checkNeighbor(BlockPos pNeighborPos) {
        Direction direction;
        ServerLevel serverLevel;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_8055_(pNeighborPos).m_60795_() && (direction = UtilLib.getDirection(this.m_58899_(), pNeighborPos)) != null) {
            this.checkDummyEntity(serverLevel, this.m_58899_()).spawnDefender(direction.m_122424_());
        }
    }

    public void m_7651_() {
        Level level;
        super.m_7651_();
        if (this.dummy_entity_id != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional.ofNullable(serverLevel.m_8791_(this.dummy_entity_id)).ifPresent(entity -> {
                entity.m_216990_(((VulnerableRemainsDummyEntity)entity).m_5592_());
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            });
        }
    }

    public void onPlaced() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.checkDummyEntity(serverLevel, this.m_58899_()).spawnDefenders();
        }
    }
}

