/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.elements.commands.sleep;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import de.geheimagentnr1.easier_sleeping.config.ServerConfig;
import de.geheimagentnr1.easier_sleeping.elements.commands.sleep.DimensionListTypeArgument;
import de.geheimagentnr1.minecraft_forge_api.elements.commands.CommandInterface;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SleepCommand
implements CommandInterface {
    @NotNull
    private final ServerConfig serverConfig;

    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder sleep = (LiteralArgumentBuilder)Commands.m_82127_((String)"sleep").requires(source -> source.m_6761_(2));
        sleep.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sleep_percent").executes(this::showSleepPercent)).then(Commands.m_82129_((String)"sleep_percent", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(this::changeSleepPercent)));
        sleep.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"message").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"wake").executes(this::showWakeMessage)).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(this::changeWakeMessage)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sleep").executes(this::showSleepMessage)).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(this::changeSleepMessage)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"morning").executes(this::showMorningMessage)).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(this::changeMorningMessage))));
        sleep.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all_players_rest").executes(this::showAllPlayersRest)).then(Commands.m_82129_((String)"all_players_rest", (ArgumentType)BoolArgumentType.bool()).executes(this::setAllPlayersRest)));
        sleep.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").executes(this::showDimensions)).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(this::addDimension)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(this::removeDimension)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list_type").executes(this::showDimensionListType)).then(Commands.m_82129_((String)"list_type", (ArgumentType)DimensionListTypeArgument.dimensionListType()).then(Commands.m_82129_((String)"invert_list", (ArgumentType)BoolArgumentType.bool()).executes(this::changeDimensionListType)))));
        return sleep;
    }

    private int showSleepPercent(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Sleep Percent: %d", this.serverConfig.getSleepPercent())), false);
        return 1;
    }

    private int changeSleepPercent(@NotNull CommandContext<CommandSourceStack> context) {
        this.serverConfig.setSleepPercent(IntegerArgumentType.getInteger(context, (String)"sleep_percent"));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Sleep Percent is now: %d", this.serverConfig.getSleepPercent())), true);
        return 1;
    }

    private int showWakeMessage(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Wake Message: %s", this.serverConfig.getWakeMessage())), false);
        return 1;
    }

    private int changeWakeMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        this.serverConfig.setWakeMessage(MessageArgument.m_96835_(context, (String)"message").getString());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Wake Message is now: %s", this.serverConfig.getWakeMessage())), true);
        return 1;
    }

    private int showSleepMessage(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Sleep Message: %s", this.serverConfig.getSleepMessage())), false);
        return 1;
    }

    private int changeSleepMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        this.serverConfig.setSleepMessage(MessageArgument.m_96835_(context, (String)"message").getString());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Sleep Message is now: %s", this.serverConfig.getSleepMessage())), true);
        return 1;
    }

    private int showMorningMessage(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Morning Message: %s", this.serverConfig.getMorningMessage())), false);
        return 1;
    }

    private int changeMorningMessage(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        this.serverConfig.setMorningMessage(MessageArgument.m_96835_(context, (String)"message").getString());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Morning Message is now: %s", this.serverConfig.getMorningMessage())), true);
        return 1;
    }

    private int showAllPlayersRest(@NotNull CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("All players rest is: %s", this.serverConfig.getAllPlayersRest())), true);
        return 1;
    }

    private int setAllPlayersRest(@NotNull CommandContext<CommandSourceStack> context) {
        this.serverConfig.setAllPlayersRest(BoolArgumentType.getBool(context, (String)"all_players_rest"));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("All players rest is now : %s", this.serverConfig.getAllPlayersRest())), true);
        return 1;
    }

    private int showDimensions(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"Dimensions:"), false);
        for (ResourceKey<Level> dimension : this.serverConfig.getDimensions()) {
            source.m_288197_(() -> Component.m_237113_((String)String.format(" - %s", dimension.m_135782_())), false);
        }
        return 1;
    }

    private int addDimension(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        this.serverConfig.addDimension((ResourceKey<Level>)dimension);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Added Dimension: %s", dimension.m_135782_())), true);
        return 1;
    }

    private int removeDimension(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        this.serverConfig.removeDimension((ResourceKey<Level>)dimension);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("Removed Dimension: %s", dimension.m_135782_())), true);
        return 1;
    }

    private int showDimensionListType(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)String.format("Dimension List Type: %s", this.serverConfig.getDimensionListType().name())), false);
        return 1;
    }

    private int changeDimensionListType(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        DimensionListType dimensionListType = DimensionListTypeArgument.getDimensionListType(context, "list_type");
        boolean revert = BoolArgumentType.getBool(context, (String)"invert_list");
        this.serverConfig.setDimensionListType(dimensionListType);
        if (revert) {
            this.serverConfig.invertDimensions();
        }
        source.m_288197_(() -> Component.m_237113_((String)String.format("Dimension List Type set to: %s", this.serverConfig.getDimensionListType().name())), false);
        source.m_288197_(() -> Component.m_237113_((String)"Dimensions:"), false);
        for (ResourceKey<Level> dimension : this.serverConfig.getDimensions()) {
            source.m_288197_(() -> Component.m_237113_((String)String.format(" - %s", dimension.m_135782_())), false);
        }
        return 1;
    }

    public SleepCommand(@NotNull ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
    }
}

