/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.effects.WerewolvesEffect;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WerewolfWeakeningEffect
extends WerewolvesEffect {
    private final List<Modifier> modifiers;

    public WerewolfWeakeningEffect(int color, List<Modifier> attributes) {
        super(MobEffectCategory.HARMFUL, color);
        this.modifiers = attributes;
    }

    public void m_6742_(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        if (!Helper.isWerewolf((Entity)entityLivingBaseIn)) {
            entityLivingBaseIn.m_21195_((MobEffect)this);
        }
    }

    public void m_6385_(@NotNull LivingEntity pLivingEntity, @NotNull AttributeMap pAttributeMap, int pAmplifier) {
        for (Map.Entry<Attribute, AttributeModifier> entry : this.getAttributeModifiers(pLivingEntity, pAmplifier).entrySet()) {
            AttributeInstance attributeinstance = pAttributeMap.m_22146_(entry.getKey());
            if (attributeinstance == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            attributeinstance.m_22120_(attributemodifier.m_22209_());
            attributeinstance.m_22125_(attributemodifier);
        }
    }

    public void m_6386_(@NotNull LivingEntity pLivingEntity, @NotNull AttributeMap pAttributeMap, int pAmplifier) {
        this.modifiers.forEach(modifier -> {
            AttributeInstance attributeinstance = pAttributeMap.m_22146_(modifier.attribute);
            if (attributeinstance != null) {
                attributeinstance.m_22120_(modifier.uuid);
            }
        });
    }

    @NotNull
    public Map<Attribute, AttributeModifier> getAttributeModifiers(@Nullable LivingEntity entity, int pAmplifier) {
        HashMap<Attribute, AttributeModifier> map = new HashMap<Attribute, AttributeModifier>();
        if (entity == null || Helper.isWerewolf((Entity)entity)) {
            IWerewolf werewolf;
            int maxLevel;
            int level;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                WerewolfPlayer werewolf2 = WerewolfPlayer.get(player);
                level = werewolf2.getLevel();
                maxLevel = werewolf2.getMaxLevel();
            } else if (entity instanceof IWerewolf && (werewolf = (IWerewolf)entity) instanceof IAdjustableLevel) {
                IAdjustableLevel levelEntity = (IAdjustableLevel)werewolf;
                level = levelEntity.getEntityLevel();
                maxLevel = levelEntity.getMaxEntityLevel();
            } else {
                level = 1;
                maxLevel = 1;
            }
            this.modifiers.forEach(modifier -> map.put(modifier.attribute, modifier.createModifier(level, maxLevel, pAmplifier)));
        }
        return map;
    }

    @NotNull
    public Map<Attribute, AttributeModifier> m_19485_() {
        return this.getAttributeModifiers(null, 0);
    }

    protected static class Modifier {
        protected final Attribute attribute;
        protected final UUID uuid;
        protected final String name;
        protected final float maxModifier;

        protected Modifier(Attribute attribute, UUID uuid, String name, float maxModifier) {
            this.attribute = attribute;
            this.uuid = uuid;
            this.name = name;
            this.maxModifier = maxModifier;
        }

        public AttributeModifier createModifier(int level, int maxLevel, int amplifier) {
            double value = LevelAttributeModifier.calculateModifierValue((int)level, (int)maxLevel, (double)this.maxModifier, (double)1.3);
            return new AttributeModifier(this.uuid, this.name, (double)(-(amplifier + 1)) * value, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }
}

