/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type.addon;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AddonProvider;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public class SkyAddon
implements AutoSyncedAddon {
    public static ResourceLocation ID = DimensionalDoors.id("sky");
    private ResourceLocation effect;
    private long dayTime = 6000L;
    private byte moonPhase;

    public boolean setEfffect(ResourceLocation effect) {
        this.effect = effect;
        return true;
    }

    public void setDayTime(long dayTime) {
        this.dayTime = dayTime;
    }

    public void setMoonPhase(byte moonPhase) {
        this.moonPhase = moonPhase;
    }

    @Override
    public PocketAddon fromNbt(CompoundTag nbt) {
        Object tag = null;
        this.effect = !nbt.m_128441_("effect") && nbt.m_128441_("world") ? ResourceLocation.m_135820_((String)nbt.m_128461_("world")) : (nbt.m_128441_("effect") ? ResourceLocation.m_135820_((String)nbt.m_128461_("effect")) : null);
        this.dayTime = nbt.m_128441_("dayTime") ? nbt.m_128454_("dayTime") : 12000L;
        this.moonPhase = nbt.m_128441_("moonPhase") ? nbt.m_128445_("moonPhase") : (byte)0;
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        AutoSyncedAddon.super.toNbt(nbt);
        nbt.m_128359_("effect", this.effect.toString());
        nbt.m_128356_("dayTime", this.dayTime);
        nbt.m_128344_("moonPhase", this.moonPhase);
        return nbt;
    }

    @Override
    public PocketAddon.PocketAddonType<? extends PocketAddon> getType() {
        return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.SKY_ADDON.get();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getEffect() {
        return this.effect;
    }

    @Override
    public AutoSyncedAddon read(FriendlyByteBuf buf) {
        this.effect = buf.m_130281_();
        this.dayTime = buf.readLong();
        this.moonPhase = buf.readByte();
        return this;
    }

    @Override
    public FriendlyByteBuf write(FriendlyByteBuf buf) {
        buf.m_130085_(this.effect);
        buf.writeLong(this.dayTime);
        buf.writeByte((int)this.moonPhase);
        return buf;
    }

    public static float timeOfDay(long dayTime) {
        double d = Mth.m_14185_((double)((double)dayTime / 24000.0 - 0.25));
        double e = 0.5 - Math.cos(d * Math.PI) / 2.0;
        return (float)(d * 2.0 + e) / 3.0f;
    }

    public float getSunAngle() {
        float f = this.getTimeOfDay();
        return f * ((float)Math.PI * 2);
    }

    public float getTimeOfDay() {
        return SkyAddon.timeOfDay(this.getDayTime());
    }

    private long getDayTime() {
        return this.dayTime;
    }

    public int getMoonPhase() {
        return this.moonPhase % 8;
    }

    public float getStarBrightness() {
        float f = this.getTimeOfDay();
        float g = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        return g * g * 0.5f;
    }

    public static interface SkyPocket
    extends AddonProvider {
        default public boolean sky(ResourceLocation effect) {
            this.ensureIsPocket();
            if (!this.hasAddon(ID)) {
                SkyAddon addon = new SkyAddon();
                this.addAddon(addon);
                return addon.setEfffect(effect);
            }
            return ((SkyAddon)this.getAddon(ID)).setEfffect(effect);
        }
    }

    public static class SkyBuilderAddon
    implements PocketAddon.PocketBuilderAddon<SkyAddon> {
        private ResourceLocation effect = BuiltinDimensionTypes.f_223542_;
        private long dayTime = 12000L;
        private byte moonPhase = 0;

        @Override
        public void apply(Pocket pocket) {
            SkyAddon addon = new SkyAddon();
            addon.effect = this.effect;
            addon.dayTime = this.dayTime;
            addon.moonPhase = this.moonPhase;
            pocket.addAddon(addon);
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        public PocketAddon.PocketBuilderAddon<SkyAddon> fromNbt(CompoundTag nbt) {
            this.effect = ResourceLocation.m_135820_((String)nbt.m_128461_("effect"));
            this.dayTime = nbt.m_128454_("dayTime");
            this.moonPhase = nbt.m_128445_("moonPhase");
            return this;
        }

        @Override
        public CompoundTag toNbt(CompoundTag nbt) {
            PocketAddon.PocketBuilderAddon.super.toNbt(nbt);
            nbt.m_128359_("effect", this.effect.toString());
            nbt.m_128356_("dayTime", this.dayTime);
            nbt.m_128344_("moonPhase", this.moonPhase);
            return nbt;
        }

        @Override
        public PocketAddon.PocketAddonType<SkyAddon> getType() {
            return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.SKY_ADDON.get();
        }
    }

    public static interface SkyPocketBuilder<T extends Pocket.PocketBuilder<T, ?>>
    extends PocketAddon.PocketBuilderExtension<T> {
        default public T dimenionType(ResourceLocation effect) {
            ((SkyBuilderAddon)this.getAddon((ResourceLocation)SkyAddon.ID)).effect = effect;
            return this.getSelf();
        }

        default public T dayTime(long dayTime) {
            ((SkyBuilderAddon)this.getAddon((ResourceLocation)SkyAddon.ID)).dayTime = dayTime;
            return this.getSelf();
        }

        default public T moonPhase(byte moonPhase) {
            ((SkyBuilderAddon)this.getAddon((ResourceLocation)SkyAddon.ID)).moonPhase = moonPhase;
            return this.getSelf();
        }
    }
}

