/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type.addon;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.addon.DyeableAddon;
import org.dimdev.dimdoors.world.pocket.type.addon.PreventBlockModificationAddon;
import org.dimdev.dimdoors.world.pocket.type.addon.SkyAddon;
import org.dimdev.dimdoors.world.pocket.type.addon.blockbreak.BlockBreakContainer;

public interface PocketAddon {
    public static final Registrar<PocketAddonType<? extends PocketAddon>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("pocket_applicable_addon_type"), (Object[])new PocketAddonType[0]).build();

    public static PocketAddon deserialize(CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        return ((PocketAddonType)REGISTRY.get(id)).fromNbt(nbt);
    }

    public static PocketBuilderAddon<?> deserializeBuilder(CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        return ((PocketAddonType)REGISTRY.get(id)).builderAddonInstance().fromNbt(nbt);
    }

    public static CompoundTag serialize(PocketAddon addon) {
        return addon.toNbt(new CompoundTag());
    }

    default public boolean applicable(Pocket pocket) {
        return true;
    }

    public PocketAddon fromNbt(CompoundTag var1);

    default public CompoundTag toNbt(CompoundTag nbt) {
        return this.getType().toNbt(nbt);
    }

    public PocketAddonType<? extends PocketAddon> getType();

    public ResourceLocation getId();

    default public void addAddon(Map<ResourceLocation, PocketAddon> addons) {
        addons.put(this.getId(), this);
    }

    public static interface PocketAddonType<T extends PocketAddon> {
        public static final RegistrySupplier<PocketAddonType<DyeableAddon>> DYEABLE_ADDON = PocketAddonType.register(DyeableAddon.ID, DyeableAddon::new, DyeableAddon.DyeableBuilderAddon::new);
        public static final RegistrySupplier<PocketAddonType<PreventBlockModificationAddon>> PREVENT_BLOCK_MODIFICATION_ADDON = PocketAddonType.register(PreventBlockModificationAddon.ID, PreventBlockModificationAddon::new, PreventBlockModificationAddon.PreventBlockModificationBuilderAddon::new);
        public static final RegistrySupplier<PocketAddonType<BlockBreakContainer>> BLOCK_BREAK_CONTAINER = PocketAddonType.register(BlockBreakContainer.ID, BlockBreakContainer::new, null);
        public static final RegistrySupplier<PocketAddonType<SkyAddon>> SKY_ADDON = PocketAddonType.register(SkyAddon.ID, SkyAddon::new, SkyAddon.SkyBuilderAddon::new);

        public T fromNbt(CompoundTag var1);

        public CompoundTag toNbt(CompoundTag var1);

        public T instance();

        public PocketBuilderAddon<T> builderAddonInstance();

        public ResourceLocation identifier();

        public static void register() {
        }

        public static <U extends PocketAddon> RegistrySupplier<PocketAddonType<U>> register(final ResourceLocation id, final Supplier<U> factory, final Supplier<PocketBuilderAddon<U>> addonSupplier) {
            return REGISTRY.register(id, () -> new PocketAddonType<U>(){

                @Override
                public U fromNbt(CompoundTag nbt) {
                    return ((PocketAddon)factory.get()).fromNbt(nbt);
                }

                @Override
                public CompoundTag toNbt(CompoundTag nbt) {
                    nbt.m_128359_("type", id.toString());
                    return nbt;
                }

                @Override
                public U instance() {
                    return (PocketAddon)factory.get();
                }

                @Override
                public PocketBuilderAddon<U> builderAddonInstance() {
                    if (addonSupplier == null) {
                        return null;
                    }
                    return (PocketBuilderAddon)addonSupplier.get();
                }

                @Override
                public ResourceLocation identifier() {
                    return id;
                }
            });
        }
    }

    public static interface PocketBuilderAddon<T extends PocketAddon> {
        default public boolean applicable(Pocket.PocketBuilder<?, ?> builder) {
            return true;
        }

        default public void addAddon(Map<ResourceLocation, PocketBuilderAddon<?>> addons) {
            addons.put(this.getId(), this);
        }

        public void apply(Pocket var1);

        public ResourceLocation getId();

        public PocketBuilderAddon<T> fromNbt(CompoundTag var1);

        default public CompoundTag toNbt(CompoundTag nbt) {
            return this.getType().toNbt(nbt);
        }

        public PocketAddonType<T> getType();
    }

    public static interface PocketBuilderExtension<T extends Pocket.PocketBuilder<T, ?>> {
        public <C extends PocketBuilderAddon<?>> C getAddon(ResourceLocation var1);

        public T getSelf();
    }
}

