/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.level.registry.forge;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionalRegistryImpl {
    public static final ResourceLocation IDENTIFIER = DimensionalDoors.id("dimensional_registry");
    public static final Capability<DimensionalRegistry> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<DimensionalRegistry>(){});

    @Mod.EventBusSubscriber(modid="dimdoors", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<DimensionalRegistry> optionalData = LazyOptional.empty();

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            DimensionalRegistry.writeToNbt(nbt);
            return nbt;
        }

        public void deserializeNBT(CompoundTag arg) {
            DimensionalRegistry.readFromNbt(arg);
        }

        @SubscribeEvent
        public static void attach(AttachCapabilitiesEvent<Level> event) {
            if (DimensionalRegistry.isValidWorld((Level)event.getObject())) {
                Provider provider = new Provider();
                event.addCapability(IDENTIFIER, (ICapabilityProvider)provider);
            }
        }
    }
}

