/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.fluid.FluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayResultType;
import org.dimdev.dimdoors.world.decay.DecaySource;

public interface DecayResult {
    public static final Codec<DecayResult> CODEC = DecayResultType.CODEC.dispatch("type", DecayResult::getType, DecayResultType::codec);

    public static <T extends DecayResult> Products.P2<RecordCodecBuilder.Mu<T>, Integer, Float> entropyCodec(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)Codec.INT.optionalFieldOf("entropy", (Object)0).forGetter(DecayResult::entropy), (App)Codec.FLOAT.optionalFieldOf("world_thread_chance", (Object)Float.valueOf(0.1f)).forGetter(DecayResult::worldThreadChance));
    }

    default public int entropy() {
        return 0;
    }

    default public float worldThreadChance() {
        return 0.0f;
    }

    public DecayResultType<? extends DecayResult> getType();

    public int process(Level var1, BlockPos var2, BlockState var3, BlockState var4, FluidState var5, DecaySource var6);

    default public Object produces(Object prior) {
        return DecayResult.defaultProduces(prior);
    }

    public static Object defaultProduces(Object object) {
        if (object instanceof Fluid) {
            Fluid fluid = (Fluid)object;
            return FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount());
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return new ItemStack((ItemLike)block);
        }
        return null;
    }
}

